/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.file;

import de.jave.figlet.file.IFigFontCategory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class FigFontCategory
implements IFigFontCategory {
    private String name;
    private String description;
    private List fontNames = new ArrayList();
    private List children = new ArrayList();
    private boolean isDynamicallyGenerated;

    public FigFontCategory(String name) {
        this.name = name;
    }

    public final void setDynamicallyGenerated(boolean isDynamicallyGenerated) {
        this.isDynamicallyGenerated = isDynamicallyGenerated;
    }

    public final Object clone() {
        FigFontCategory clone = new FigFontCategory(this.name);
        clone.setDynamicallyGenerated(this.isDynamicallyGenerated());
        clone.setDescription(this.getDescription());
        FigFontCategory[] childCategories = this.getChildCategories();
        for (int i = 0; i < childCategories.length; ++i) {
            clone.addChild((FigFontCategory)childCategories[i].clone());
        }
        clone.fontNames = new ArrayList(this.fontNames);
        return clone;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final void addFontName(String fontName) {
        this.fontNames.add(fontName);
    }

    public final void addFontNames(String[] fontNames) {
        this.fontNames.addAll(Arrays.asList(fontNames));
    }

    public final int getFontCount() {
        return this.fontNames.size();
    }

    public final String[] getFontNames() {
        Object[] names = this.fontNames.toArray(new String[this.getFontCount()]);
        Arrays.sort(names);
        return names;
    }

    public final FigFontCategory[] getChildCategories() {
        return this.children.toArray(new FigFontCategory[this.children.size()]);
    }

    public final void addChild(FigFontCategory child) {
        this.children.add(child);
    }

    public final FigFontCategory getChildCategory(String name) {
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            FigFontCategory element = (FigFontCategory)iter.next();
            if (!element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    public final boolean containsFont(String fontName) {
        return this.fontNames.contains(fontName);
    }

    public final boolean isDynamicallyGenerated() {
        return this.isDynamicallyGenerated;
    }
}

