/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.file;

import de.jave.figlet.file.FigFileName;
import de.jave.figlet.file.FigFontCategorization;
import de.jave.figlet.file.IFigFileResource;
import de.jave.figlet.io.FigCategoriesFileParser;
import de.jave.figlet.util.FigException;
import de.jave.lib.Toolbox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import net.disy.commons.core.util.Ensure;

public final class FigFileLibrary {
    private IFigFileResource fileResource;
    private String[] fontNames;
    private String defaultFontName;
    private String[] controlNames;
    private FigFontCategorization categorization;

    private FigFileLibrary(IFigFileResource fileResource) {
        Ensure.ensureArgumentNotNull(fileResource);
        this.fileResource = fileResource;
    }

    private static FigFileName[] removeDuplicatesAndSort(FigFileName[] filenames) {
        HashSet<String> fontSet = new HashSet<String>();
        ArrayList<FigFileName> fileNameList = new ArrayList<FigFileName>();
        for (int i = 0; i < filenames.length; ++i) {
            if (fontSet.contains(filenames[i].getName())) continue;
            fontSet.add(filenames[i].getName());
            fileNameList.add(filenames[i]);
        }
        FigFileName[] resultFileNames = fileNameList.toArray(new FigFileName[fileNameList.size()]);
        Arrays.sort(resultFileNames, new Comparator(){

            public final int compare(Object o1, Object o2) {
                String name1 = ((FigFileName)o1).getName().toLowerCase();
                String name2 = ((FigFileName)o1).getName().toLowerCase();
                return name1.compareTo(name2);
            }
        });
        return resultFileNames;
    }

    public final void initialize() throws FigException {
        this.fontNames = new String[0];
        this.controlNames = new String[0];
        FigFileName[] figletFileNames = this.fileResource.loadFigletFileNames();
        if (figletFileNames == null) {
            throw new FigException("Unable to load index file containing a list of all font/control files (" + this.fileResource.getRourceBaseDescription() + ")", 1);
        }
        figletFileNames = FigFileLibrary.removeDuplicatesAndSort(figletFileNames);
        int fontCount = 0;
        int controlCount = 0;
        for (int i = 0; i < figletFileNames.length; ++i) {
            if (figletFileNames[i].isFont()) {
                ++fontCount;
                continue;
            }
            if (!figletFileNames[i].isControlFile()) continue;
            ++controlCount;
        }
        if (fontCount == 0) {
            throw new FigException("Figlet font list empty (" + this.fileResource.getRourceBaseDescription() + ")", 3);
        }
        this.fontNames = new String[fontCount];
        this.controlNames = new String[controlCount];
        int i1 = 0;
        int i2 = 0;
        for (int i = 0; i < figletFileNames.length; ++i) {
            if (figletFileNames[i].isFont()) {
                this.fontNames[i1] = figletFileNames[i].getPrintName();
                if (i1 == 0 || this.fontNames[i1].equals("standard")) {
                    this.defaultFontName = this.fontNames[i1];
                }
                ++i1;
                continue;
            }
            if (!figletFileNames[i].isControlFile()) continue;
            this.controlNames[i2++] = figletFileNames[i].getPrintName();
        }
        Toolbox.quickSort(this.fontNames);
        Toolbox.quickSort(this.controlNames);
        try {
            this.categorization = new FigCategoriesFileParser().loadCategoriesFile(this.fontNames, this.fileResource, "categoriestree.txt");
            return;
        }
        catch (Exception e) {
            System.err.println("Error loading categoriestree.txt:" + e);
            try {
                this.categorization = new FigCategoriesFileParser().loadCategoriesFile(this.fontNames, this.fileResource, "categories.txt");
                return;
            }
            catch (Exception exception) {
                this.categorization = FigFontCategorization.createFallBackCategorization(this.fontNames);
                throw new FigException("No figlet font categories file found or wrong format (" + this.fileResource.getRourceBaseDescription() + ")", e, 4);
            }
        }
    }

    public final String[] getAllFontNames() {
        return this.fontNames;
    }

    public final String getDefaultFontName() {
        return this.defaultFontName;
    }

    public static final FigFileLibrary loadFileLibrary(IFigFileResource fileResource) throws FigException {
        FigFileLibrary fileLibrary = new FigFileLibrary(fileResource);
        fileLibrary.initialize();
        return fileLibrary;
    }

    public final IFigFileResource getFileResource() {
        return this.fileResource;
    }

    public final FigFontCategorization getFontCategorization() {
        return this.categorization;
    }
}

