/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.file;

import de.jave.figlet.file.AbstractFigFileResource;
import de.jave.figlet.file.FigFileName;
import de.jave.figlet.util.FigException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;

public final class BaseFolderFigFileResource
extends AbstractFigFileResource {
    private final File folder;

    public BaseFolderFigFileResource(File folder) throws FigException {
        if (!folder.exists()) {
            throw new FigException("Base folder for figlet files does not exist: '" + folder.getAbsolutePath() + "'");
        }
        if (!folder.isDirectory()) {
            throw new FigException("Base folder for figlet files is not a directory: '" + folder.getAbsolutePath() + "'");
        }
        if (!folder.canRead()) {
            throw new FigException("Base folder for figlet files can not be read: '" + folder.getAbsolutePath() + "'");
        }
        this.folder = folder;
    }

    public final InputStream openConfigurationFileInputStream(String fileName) {
        try {
            return this.openInputStream(fileName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    private InputStream openInputStream(String filename) throws FileNotFoundException {
        File file = new File(this.folder, filename);
        return new FileInputStream(file);
    }

    public final FigFileName[] loadFigletFileNames() throws FigException {
        String[] names = this.folder.list(new FilenameFilter(this){

            public final boolean accept(File dir, String name) {
                String lowerCaseName = name.toLowerCase();
                return lowerCaseName.endsWith(".flf") || lowerCaseName.endsWith(".flc");
            }
        });
        if (names == null) {
            throw new FigException("Unable to list directory for fonts: '" + this.folder.getAbsolutePath() + "'");
        }
        return this.createFigFileNames(names);
    }

    public final InputStream openFigFileInputStream(FigFileName fileDescription) throws FigException {
        try {
            return this.openInputStream(fileDescription.getName());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FigException("Requested file '" + fileDescription.getName() + "' does not exist (" + this.getRourceBaseDescription() + ").");
        }
    }

    public final String getRourceBaseDescription() {
        return "folder " + this.folder.getAbsolutePath();
    }

    public final File getBaseFolder() {
        return this.folder;
    }
}

