/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.engine.primitives;

public final class VerticalSmushingRules {
    private int layout;

    public VerticalSmushingRules(int layout) {
        this.layout = layout;
    }

    public VerticalSmushingRules() {
        this.layout = 0;
    }

    public final boolean isEqualCharacter() {
        return this.isSet(256);
    }

    public final boolean isUnderscore() {
        return this.isSet(512);
    }

    public final boolean isHierarchy() {
        return this.isSet(1024);
    }

    public final boolean isHorizontalLine() {
        return this.isSet(2048);
    }

    public final boolean isVerticalLine() {
        return this.isSet(4096);
    }

    public final boolean isNoRulesSpecified() {
        return (this.layout & 0x1F00) == 0;
    }

    public final VerticalSmushingRules intersect(VerticalSmushingRules other) {
        return new VerticalSmushingRules(this.layout & other.layout);
    }

    private boolean isSet(int flag) {
        return (this.layout & flag) == flag;
    }

    private void set(int flag, boolean b) {
        this.layout = (this.layout | flag) - flag;
        if (b) {
            this.layout |= flag;
        }
    }

    public final void setEqualCharacter(boolean b) {
        this.set(256, b);
    }

    public final void setHierarchy(boolean b) {
        this.set(1024, b);
    }

    public final void setUnderscore(boolean b) {
        this.set(512, b);
    }

    public final void setHorizontalLine(boolean b) {
        this.set(2048, b);
    }

    public final void setVerticalLine(boolean b) {
        this.set(4096, b);
    }

    public final Object clone() {
        return new VerticalSmushingRules(this.layout);
    }
}

