/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.engine.primitives;

import de.jave.figlet.engine.primitives.FigCharacter;
import de.jave.figlet.engine.primitives.FigFontOptions;
import de.jave.figlet.engine.primitives.FigLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class FigFont {
    private final HashMap characterMapping = new HashMap();
    private final List characters = new ArrayList();
    private final String name;
    private final FigFontOptions options;

    public FigFont(String name, FigFontOptions options) {
        this.options = options;
        this.name = name;
    }

    public final void addCharacter(FigCharacter character) {
        this.characters.add(character);
        this.characterMapping.put(new Integer(character.getCharacterCode()), character);
    }

    public final String getComments() {
        return this.options.getComments();
    }

    public final int getHeight() {
        return this.options.getHeight();
    }

    public final int getUnderLength() {
        return this.options.getHeight() - this.options.getBaseline();
    }

    public final FigCharacter getFIGCharacter(int ch) {
        if (this.characterMapping.containsKey(new Integer(ch))) {
            return (FigCharacter)this.characterMapping.get(new Integer(ch));
        }
        return (FigCharacter)this.characterMapping.get(new Integer(32));
    }

    public final FigLayout getLayout() {
        return this.options.getLayout();
    }

    public final String getName() {
        return this.name;
    }

    public final FigFontOptions getOptions() {
        return this.options;
    }
}

