/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.engine;

import de.jave.figlet.engine.FigDriver;
import de.jave.figlet.engine.processing.IFigletJob;
import de.jave.lib.job.IJobProcessor;
import de.jave.lib.job.IResultConsumer;
import de.jave.lib.job.JobProcessingContext;
import de.jave.lib.job.NullWarningCollector;
import net.disy.commons.core.util.Ensure;

public final class FigConversionJobProcessor
implements IJobProcessor {
    private NullWarningCollector warner;
    private FigDriver figDriver;
    private IResultConsumer resultConsumer;

    public FigConversionJobProcessor(FigDriver figDriver, IResultConsumer resultConsumer, NullWarningCollector warner) {
        Ensure.ensureArgumentNotNull(warner);
        Ensure.ensureArgumentNotNull(figDriver);
        this.warner = warner;
        this.resultConsumer = resultConsumer;
        this.figDriver = figDriver;
    }

    public final void process(JobProcessingContext job) {
        String t;
        IFigletJob figletJob = (IFigletJob)job.getJobObject();
        try {
            t = this.figDriver.figletize(figletJob);
        }
        catch (Exception e) {
            if (this.warner != null) {
                String cfr_ignored_0 = "Error with FIGML! " + e.toString();
            }
            e.printStackTrace();
            t = e.toString();
        }
        this.resultConsumer.putResult(t);
    }
}

