/*
 * Decompiled with CFR 0.152.
 */
package de.jave.braille.table;

import de.jave.braille.table.EuroBrailleTable;
import de.jave.braille.table.FrenchBrailleTable;
import de.jave.braille.table.GermanBrailleTable;
import de.jave.braille.table.IBrailleTable;
import de.jave.braille.table.UkBrailleTable;
import de.jave.braille.table.UsBrailleTable;

public final class BrailleTables {
    private static final IBrailleTable[] TABLES = new IBrailleTable[]{new EuroBrailleTable(), new GermanBrailleTable(), new FrenchBrailleTable(), new UkBrailleTable(), new UsBrailleTable()};

    public static final IBrailleTable getDefaultTable() {
        return TABLES[0];
    }

    public static final String[] getAvailableTableNames() {
        String[] result = new String[TABLES.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = TABLES[i].getName();
        }
        return result;
    }

    public static final IBrailleTable getByName(String name) {
        for (int i = 0; i < TABLES.length; ++i) {
            if (!name.equals(TABLES[i].getName())) continue;
            return TABLES[i];
        }
        return null;
    }
}

