/*
 * Decompiled with CFR 0.152.
 */
package de.jave.awt.clipboard;

import de.jave.lib.BooleanPlate;
import de.jave.lib.CharacterPlate;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;

public final class JaveClipboardSelection
implements Transferable,
ClipboardOwner {
    protected CharacterPlate content;
    protected BooleanPlate mask;
    private static final DataFlavor[] flavors = new DataFlavor[3];

    public JaveClipboardSelection(String s) {
        this.content = new CharacterPlate(s);
        this.mask = null;
    }

    public JaveClipboardSelection(CharacterPlate content) {
        this(content, null);
    }

    public JaveClipboardSelection(CharacterPlate content, BooleanPlate mask) {
        this.content = content.getClone();
        if (mask != null) {
            this.mask = mask.getClone();
        }
    }

    public final DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])flavors.clone();
    }

    public final boolean isDataFlavorSupported(DataFlavor flavor) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!flavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    public final Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(flavors[0])) {
            return this;
        }
        if (flavor.equals(flavors[1])) {
            return this.content.toString();
        }
        if (flavor.equals(flavors[2])) {
            return new StringReader(this.content.toString());
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public final CharacterPlate getContent() {
        return this.content;
    }

    public final BooleanPlate getMask() {
        return this.mask;
    }

    public final void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    static {
        try {
            JaveClipboardSelection.flavors[0] = new DataFlavor(Class.forName("de.jave.jave.JaveSelection"), "JavE Selection");
        }
        catch (Exception e) {
            System.err.println("!!! Serious problem in de.jave.jave.JaveSelection.static :" + e);
        }
        JaveClipboardSelection.flavors[1] = DataFlavor.stringFlavor;
        JaveClipboardSelection.flavors[2] = DataFlavor.plainTextFlavor;
    }
}

