/*
 * Decompiled with CFR 0.152.
 */
package de.jave.asciimation.export.gif;

import de.jave.asciimation.export.AbstractAnimationExported;
import de.jave.asciimation.export.AnimationExportOptions;
import de.jave.jave.AsciiToThumbnailConverter;
import de.jave.jave.version.JaveTitleProvider;
import de.jave.javeplayer.AnimationMetaData;
import de.jave.javeplayer.AnimationProperties;
import de.jave.lib.CharacterPlate;
import de.jave.text.TextTools;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import net.disy.commons.core.io.IOUtilities;
import net.disy.commons.core.util.Ensure;
import net.jmge.gif.Gif89Encoder;

public final class MultipleGifsAnimationExporter
extends AbstractAnimationExported {
    private final AnimationExportOptions options;
    private int ciffers;
    private int frameCount = 0;
    private AnimationProperties animationProperties;

    public MultipleGifsAnimationExporter(AnimationExportOptions options) {
        Ensure.ensureArgumentNotNull(options);
        this.options = options;
    }

    public final void init(Dimension maxFrameSize, AnimationProperties animationProperties, int frameCount, AnimationMetaData metaData) throws Exception {
        this.animationProperties = animationProperties;
        this.ciffers = 1;
        --frameCount;
        while (frameCount >= 10) {
            frameCount /= 10;
            ++this.ciffers;
        }
    }

    public final void writeFrame(CharacterPlate content) throws Exception {
        BufferedImage resultImage = AsciiToThumbnailConverter.convert(content, this.options.getAdditionalOptions().getGifScale(), this.options.getAdditionalOptions().getGifFont(), this.animationProperties.getBackgroundColor(), this.animationProperties.getForegroundColor(), this.options.getAdditionalOptions().isConnectedLinesView());
        Gif89Encoder encoder = new Gif89Encoder(resultImage);
        encoder.setComments(JaveTitleProvider.CREATED_BY_JAVE);
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.options.getFileNameWithoutExtension() + "_" + TextTools.fillFront(String.valueOf(this.frameCount), '0', this.ciffers) + ".gif"));
        encoder.encode(output);
        IOUtilities.close(output);
        ++this.frameCount;
    }

    public final void finish() throws Exception {
    }

    public final void rollBack() {
    }
}

