/*
 * Decompiled with CFR 0.152.
 */
package de.jave.asciimation.export.gif;

import de.jave.asciimation.export.AbstractAnimationExported;
import de.jave.asciimation.export.AnimationExportOptions;
import de.jave.jave.AsciiToThumbnailConverter;
import de.jave.jave.version.JaveTitleProvider;
import de.jave.javeplayer.AnimationMetaData;
import de.jave.javeplayer.AnimationProperties;
import de.jave.lib.CharacterPlate;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import net.disy.commons.core.io.IOUtilities;
import net.disy.commons.core.util.Ensure;
import net.jmge.gif.DirectGif89Frame;
import net.jmge.gif.Gif89Encoder;

public final class AnimatedGifAnimationExporter
extends AbstractAnimationExported {
    private final AnimationExportOptions options;
    private Gif89Encoder gifEncoder;
    private AnimationProperties animationProperties;

    public AnimatedGifAnimationExporter(AnimationExportOptions options) {
        Ensure.ensureArgumentNotNull(options);
        this.options = options;
    }

    public final void init(Dimension maxFrameSize, AnimationProperties animationProperties, int frameCount, AnimationMetaData metaData) throws Exception {
        this.animationProperties = animationProperties;
        this.gifEncoder = new Gif89Encoder();
        this.gifEncoder.setComments(JaveTitleProvider.CREATED_BY_JAVE);
        this.gifEncoder.setLoopCount(this.options.getAdditionalOptions().isLoop() ? 0 : 1);
    }

    public final void writeFrame(CharacterPlate content) throws Exception {
        BufferedImage resultImage2 = AsciiToThumbnailConverter.convert(content, this.options.getAdditionalOptions().getGifScale(), this.options.getAdditionalOptions().getGifFont(), this.animationProperties.getBackgroundColor(), this.animationProperties.getForegroundColor(), this.options.getAdditionalOptions().isConnectedLinesView());
        DirectGif89Frame gifFrame = new DirectGif89Frame(resultImage2);
        gifFrame.setDelay(this.animationProperties.getFrameDuration() / 10);
        this.gifEncoder.addFrame(gifFrame);
    }

    public final void finish() throws Exception {
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.options.getFile()));
        this.gifEncoder.encode(output);
        IOUtilities.close(output);
    }

    public final void rollBack() {
    }
}

