/*
 * Decompiled with CFR 0.152.
 */
package de.jave.asciimation.export;

import de.jave.asciimation.export.AnimationExportFormatRegistry;
import de.jave.asciimation.export.AnimationExportWizardModel;
import de.jave.asciimation.export.IAnimationExportFormat;
import de.jave.jave.JaveGlobalRessources;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.disy.commons.core.message.BasicMessage;
import net.disy.commons.core.message.IBasicMessage;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.dialog.wizard.AbstractWizardPage;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.ui.IObjectUi;
import net.disy.commons.swing.ui.ObjectUiListCellRenderer;

public final class AnimationExportFormatPage
extends AbstractWizardPage {
    private JList list;
    private JTextArea descriptionTextArea;
    private final AnimationExportWizardModel model;

    public AnimationExportFormatPage(String title, AnimationExportWizardModel model) {
        super(title, new BasicMessage("Select an export format for animation export."));
        Ensure.ensureArgumentNotNull(model);
        this.model = model;
    }

    public final IBasicMessage createCurrentMessage() {
        if (this.model.getExportOptions().getFormat() == null) {
            return new BasicMessage("There is no format selected. Please select a format for export.", MessageType.ERROR);
        }
        return this.getDefaultMessage();
    }

    public final JComponent createContent() {
        IAnimationExportFormat[] formats = AnimationExportFormatRegistry.getAllExportFormats();
        this.list = new JList<IAnimationExportFormat>(formats);
        this.list.setSelectionMode(1);
        this.list.setCellRenderer(new ObjectUiListCellRenderer(new IObjectUi(this){

            public final String getLabel(Object value) {
                IAnimationExportFormat format = (IAnimationExportFormat)value;
                return format.getName();
            }

            public final Icon getIcon(Object value) {
                IAnimationExportFormat format = (IAnimationExportFormat)value;
                return format.getIcon();
            }
        }));
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public final void valueChanged(ListSelectionEvent e) {
                AnimationExportFormatPage.this.updateDescriptionLabel();
                AnimationExportFormatPage.this.model.getExportOptions().setFormat((IAnimationExportFormat)AnimationExportFormatPage.this.list.getSelectedValue());
                AnimationExportFormatPage.this.checkInputValid();
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            public final void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    AnimationExportFormatPage.this.getWizard().getContainer().requestNext();
                }
            }
        });
        JPanel panel = new JPanel(new GridDialogLayout(1, false));
        panel.add(new JLabel("Select an export destination:"));
        panel.add((Component)new JScrollPane(this.list), GridDialogLayoutData.FILL_BOTH);
        panel.add(new JLabel("Description:"));
        this.descriptionTextArea = new JTextArea(5, 50);
        this.descriptionTextArea.setFont(JaveGlobalRessources.FONT_SMALL);
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setWrapStyleWord(true);
        panel.add((Component)new JScrollPane(this.descriptionTextArea), GridDialogLayoutData.FILL_HORIZONTAL);
        this.updateDescriptionLabel();
        return panel;
    }

    private void updateDescriptionLabel() {
        IAnimationExportFormat format = this.model.getExportOptions().getFormat();
        if (format == null) {
            this.descriptionTextArea.setText(" - No format selected -");
            return;
        }
        this.descriptionTextArea.setText(format.getDescription());
    }

    public final boolean canFlipToNextPage() {
        if (this.getNextPage() == null) {
            return false;
        }
        if (this.getMessage().getType() == MessageType.ERROR) {
            return false;
        }
        return this.createCurrentMessage().getType() != MessageType.ERROR;
    }

    public final boolean canFinish() {
        return false;
    }

    public final void pageActivated() {
    }

    public final void performHelp() {
        throw new UnsupportedOperationException();
    }

    public final boolean isHelpAvailable() {
        return false;
    }

    public final void requestFocus() {
        this.list.requestFocus();
    }
}

