/*
 * Decompiled with CFR 0.152.
 */
package de.jave.asciimation.editor;

import de.jave.asciimation.editor.AnimationEditorModel;
import de.jave.jave.application.resources.JaveImageProvider;
import de.jave.javeplayer.JaveAnimationFrame;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import net.disy.commons.core.util.Ensure;

public final class JaveAnimationFrameListCellRenderer
extends DefaultListCellRenderer {
    private static final Icon FRAME_ICON = JaveImageProvider.getInstance().getImageIcon("animation/frame.gif");
    private static final Icon CURRENT_FRAME_ICON = JaveImageProvider.getInstance().getImageIcon("animation/current_frame.gif");
    private final AnimationEditorModel model;

    public JaveAnimationFrameListCellRenderer(AnimationEditorModel model) {
        Ensure.ensureArgumentNotNull(model);
        this.model = model;
    }

    public final Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        JaveAnimationFrame frame = (JaveAnimationFrame)value;
        String frameTitle = frame.getTool();
        if (frameTitle == null) {
            frameTitle = "Frame " + (index + 1);
        }
        String text = index + 1 + ": " + frameTitle;
        this.setIcon(index == this.model.getCurrentFrameIndexModel().getCurrentFrameIndex() ? CURRENT_FRAME_ICON : FRAME_ICON);
        this.setText(text);
        return this;
    }
}

