/*
 * Decompiled with CFR 0.152.
 */
package de.jave.asciimation.editor;

import de.jave.asciimation.editor.AnimationEditorModel;
import de.jave.asciimation.editor.ListSelectionUtilities;
import de.jave.jave.application.resources.JaveImageProvider;
import de.jave.javeplayer.JaveAnimationFile;
import java.awt.Component;
import javax.swing.JPopupMenu;
import net.disy.commons.swing.action.SmartAction;

public final class AnimationEditorPopupMenuFactory {
    public static final JPopupMenu createFramePopupMenu(final AnimationEditorModel model) {
        final int[] selectedItems = ListSelectionUtilities.getSelectedIndices(model.getFrameSelectionModel());
        JaveAnimationFile animationFile = model.getAnimationFile();
        SmartAction deleteAction = new SmartAction("Delete", JaveImageProvider.getInstance().getImageIcon("animation/delete_frame.gif")){

            protected final void execute(Component parentComponent) {
                for (int i = selectedItems.length - 1; i >= 0; --i) {
                    model.deleteFrame(selectedItems[i]);
                }
            }
        };
        deleteAction.setEnabled(selectedItems.length > 0 && selectedItems.length < animationFile.getFrameCount());
        SmartAction moveLeftAction = new SmartAction("Move left", JaveImageProvider.getInstance().getImageIcon("animation/move_left.gif")){

            protected final void execute(Component parentComponent) {
                model.moveFrameLeft(selectedItems[0]);
            }
        };
        moveLeftAction.setEnabled(selectedItems.length == 1 && selectedItems[0] > 0);
        SmartAction moveRightAction = new SmartAction("Move right", JaveImageProvider.getInstance().getImageIcon("animation/move_right.gif")){

            protected final void execute(Component parentComponent) {
                model.moveFrameRight(selectedItems[0]);
            }
        };
        moveRightAction.setEnabled(selectedItems.length == 1 && selectedItems[0] < animationFile.getFrameCount() - 1);
        SmartAction selectAllAction = new SmartAction("Select all"){

            protected final void execute(Component parentComponent) {
                model.getFrameSelectionModel().addSelectionInterval(0, model.getAnimationFile().getFrameCount() - 1);
            }
        };
        selectAllAction.setEnabled(selectedItems.length < animationFile.getFrameCount());
        SmartAction unselectAllAction = new SmartAction("Unselect all"){

            protected final void execute(Component parentComponent) {
                model.getFrameSelectionModel().clearSelection();
            }
        };
        unselectAllAction.setEnabled(selectedItems.length > 0);
        SmartAction reverseAction = new SmartAction("Reverse", JaveImageProvider.getInstance().getImageIcon("animation/reverse.gif")){

            protected final void execute(Component parentComponent) {
                if (selectedItems == null || selectedItems.length == 0) {
                    return;
                }
                int startIndex = selectedItems[0];
                int endIndex = selectedItems[selectedItems.length - 1];
                model.doFramesRevert(startIndex, endIndex);
            }
        };
        reverseAction.setEnabled(selectedItems.length > 1 && AnimationEditorPopupMenuFactory.isContinuousSelection(selectedItems));
        JPopupMenu popupMenuFrames = new JPopupMenu();
        popupMenuFrames.add(deleteAction);
        popupMenuFrames.add(reverseAction);
        popupMenuFrames.addSeparator();
        popupMenuFrames.add(moveLeftAction);
        popupMenuFrames.add(moveRightAction);
        popupMenuFrames.addSeparator();
        popupMenuFrames.add(selectAllAction);
        popupMenuFrames.add(unselectAllAction);
        return popupMenuFrames;
    }

    private static final boolean isContinuousSelection(int[] selectedItems) {
        return selectedItems.length == selectedItems[selectedItems.length - 1] - selectedItems[0] + 1;
    }
}

