/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.EventObject;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import net.disy.commons.core.exception.UnreachableCodeReachedException;
import net.disy.commons.core.geometry.SmartRectangle;
import net.disy.commons.swing.util.RelativePosition;

public final class GuiUtilities {
    protected GuiUtilities() {
        throw new UnreachableCodeReachedException();
    }

    public static final Window getWindowForComponent(EventObject event) {
        if (event == null) {
            return JOptionPane.getRootFrame();
        }
        Object object = event.getSource();
        if (object instanceof Component) {
            return GuiUtilities.getWindowForComponent((Component)object);
        }
        return JOptionPane.getRootFrame();
    }

    public static final Window getWindowForComponent(Component component) {
        if (component == null) {
            return JOptionPane.getRootFrame();
        }
        if (component instanceof JPopupMenu) {
            return GuiUtilities.getWindowForComponent(((JPopupMenu)component).getInvoker());
        }
        if (component instanceof Window) {
            return (Window)component;
        }
        return GuiUtilities.getWindowForComponent(component.getParent());
    }

    public static final void placeRelativeToOwner(Window window, RelativePosition position) {
        position.place(window);
        GuiUtilities.assureIsOnScreen(window);
    }

    public static final void centerOnScreen(Window window) {
        Point screenCenter = new SmartRectangle(GuiUtilities.getScreenBounds(window)).getCenter();
        GuiUtilities.centerToPoint(window, screenCenter);
    }

    public static final Rectangle getScreenBounds(Component component) {
        return component.getGraphicsConfiguration().getBounds();
    }

    public static final void centerToPoint(Window window, Point center) {
        Dimension size = window.getSize();
        int x = center.x - size.width / 2;
        int y = center.y - size.height / 2;
        x = x < 0 ? 0 : x;
        y = y < 0 ? 0 : y;
        window.setLocation(x, y);
    }

    public static final JDialog createDialog(Component parentComponent, String title) {
        Window window = GuiUtilities.getWindowForComponent(parentComponent);
        JDialog dialog = window instanceof Frame ? new JDialog((Frame)window) : (window instanceof Dialog ? new JDialog((Dialog)window) : new JDialog());
        dialog.setTitle(title);
        GuiUtilities.accountForScreenSize(dialog);
        return dialog;
    }

    public static final void accountForScreenSize(Window window) {
        window.addComponentListener(new ComponentAdapter(){

            public final void componentResized(ComponentEvent e) {
                GuiUtilities.assureIsOnScreen((Window)e.getSource());
            }
        });
    }

    public static final void assureIsOnScreen(Window window) {
        Point newLocation = GuiUtilities.calculateScreenFittingLocation(window, new SmartRectangle(window.getBounds()));
        if (!window.getLocation().equals(newLocation)) {
            window.setLocation(newLocation);
        }
    }

    public static final Point calculateScreenFittingLocation(Component screenComponent, Rectangle rectangle) {
        GraphicsConfiguration graphicsConfiguration = screenComponent.getGraphicsConfiguration();
        Rectangle screenBounds = graphicsConfiguration.getBounds();
        int x = (int)Math.max((double)screenBounds.x, Math.min(screenBounds.getMaxX() - (double)rectangle.width, (double)rectangle.x));
        int y = (int)Math.max((double)screenBounds.y, Math.min(screenBounds.getMaxY() - (double)rectangle.height, (double)rectangle.y));
        return new Point(x, y);
    }
}

