/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public final class VFlowLayout
implements LayoutManager,
Serializable {
    private int align;
    private int hgap;
    private int vgap;

    public VFlowLayout() {
        this(1, 5, 5);
    }

    public VFlowLayout(int align, int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
        this.setAlignment(align);
    }

    public final void setAlignment(int align) {
        this.align = align;
    }

    public final void addLayoutComponent(String name, Component comp) {
    }

    public final void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            boolean firstVisibleComponent = true;
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                dim.width = Math.max(dim.width, d.width);
                if (firstVisibleComponent) {
                    firstVisibleComponent = false;
                } else {
                    dim.height += this.vgap;
                }
                dim.height += d.height;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.hgap * 2;
            dim.height += insets.top + insets.bottom + this.vgap * 2;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getMinimumSize();
                dim.width = Math.max(dim.width, d.width);
                if (i > 0) {
                    dim.height += this.vgap;
                }
                dim.height += d.height;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.hgap * 2;
            dim.height += insets.top + insets.bottom + this.vgap * 2;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveComponents(Container target, int x, int y, int width, int height, int rowStart, int rowEnd) {
        Object object = target.getTreeLock();
        synchronized (object) {
            switch (this.align) {
                case 0: {
                    break;
                }
                case 1: {
                    y += height / 2;
                    break;
                }
                case 2: {
                    y += height;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    y += height;
                }
            }
            for (int i = rowStart; i < rowEnd; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getSize();
                m.setLocation(x + (width - d.width) / 2, y);
                y += d.height + this.vgap;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int maxheight = target.getSize().height - (insets.top + insets.bottom + this.vgap * 2);
            int nmembers = target.getComponentCount();
            int x = insets.left + this.hgap;
            int y = 0;
            int rowW = 0;
            int start = 0;
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                m.setSize(d.width, d.height);
                if (y == 0 || y + d.height <= maxheight) {
                    if (y > 0) {
                        y += this.vgap;
                    }
                    y += d.height;
                    rowW = Math.max(rowW, d.width);
                    continue;
                }
                this.moveComponents(target, x, insets.top + this.vgap, rowW, maxheight - y, start, i);
                y = d.height;
                x += this.hgap + rowW;
                rowW = d.width;
                start = i;
            }
            this.moveComponents(target, x, insets.top + this.vgap, rowW, maxheight - y, start, nmembers);
            return;
        }
    }

    public final String toString() {
        String str = "";
        switch (this.align) {
            case 0: {
                str = ",align=top";
                break;
            }
            case 1: {
                str = ",align=center";
                break;
            }
            case 2: {
                str = ",align=bottom";
                break;
            }
            case 3: {
                str = ",align=leading";
                break;
            }
            case 4: {
                str = ",align=trailing";
            }
        }
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + str + "]";
    }
}

