/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.dialog.userdialog;

import java.awt.Component;
import net.disy.commons.swing.dialog.userdialog.IDialogConfiguration;
import net.disy.commons.swing.dialog.userdialog.IDialogPage;
import net.disy.commons.swing.dialog.userdialog.buttons.DialogButtonConfiguration;

public abstract class AbstractDialogConfiguration
implements IDialogConfiguration {
    private boolean modal = true;
    private final IDialogPage dialogPage;
    private final DialogButtonConfiguration buttonConfiguration;

    public AbstractDialogConfiguration(IDialogPage dialogPage) {
        this(dialogPage, DialogButtonConfiguration.createBoth());
    }

    public AbstractDialogConfiguration(IDialogPage dialogPage, DialogButtonConfiguration buttonConfiguration) {
        this.dialogPage = dialogPage;
        this.buttonConfiguration = buttonConfiguration;
    }

    public final IDialogPage getDialogPage() {
        return this.dialogPage;
    }

    public final String getOkButtonText() {
        return this.buttonConfiguration.getOkayButtonText();
    }

    public final String getCancelButtonText() {
        return this.buttonConfiguration.getCancelButtonText();
    }

    public final Component[] createAdditionalButtons() {
        return new Component[0];
    }

    public boolean isModal() {
        return this.modal;
    }

    public boolean performOk(Component parentComponent) {
        return true;
    }

    public final boolean performCancel(Component parentComponent) {
        return true;
    }

    public boolean isHeaderPanelVisible() {
        return true;
    }

    public boolean isCancelAvailable() {
        return this.buttonConfiguration.isCancelButtonAvailable();
    }

    public final boolean isOkButtonAvailable() {
        return this.buttonConfiguration.isOkayButtonAvailable();
    }
}

