/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.dialog.core;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.disy.commons.core.message.IBasicMessage;
import net.disy.commons.swing.dialog.core.IDialogConstants;
import net.disy.commons.swing.layout.VFlowLayout;
import net.disy.commons.swing.message.MessageTypeUi;
import net.disy.commons.swing.widgets.AutoWrappingLabel;
import net.disy.commons.swing.widgets.HorizontalLine;

public final class DialogHeaderPanel
implements IDialogConstants {
    private static final Color BACKGROUND_COLOR = Color.WHITE;
    private static final Color TEXT_COLOR = Color.BLACK;
    private AutoWrappingLabel messageLabel;
    private final JLabel descriptionLabel = new JLabel("!Dialog.description!", 2);
    private final JLabel messageTypeIconLabel;
    private JComponent content;

    public DialogHeaderPanel() {
        this.descriptionLabel.setForeground(TEXT_COLOR);
        this.messageTypeIconLabel = new JLabel();
        this.messageLabel = new AutoWrappingLabel("!Dialog.message!", 330);
        this.messageLabel.setBackground(BACKGROUND_COLOR);
        this.messageLabel.setForeground(TEXT_COLOR);
    }

    public final JComponent getContent() {
        if (this.content == null) {
            this.messageLabel.setFont(IDialogConstants.MESSAGE_LABEL_FONT);
            this.descriptionLabel.setFont(this.descriptionLabel.getFont().deriveFont(1));
            JPanel iconPanel = new JPanel(new VFlowLayout(0, 3, 0));
            iconPanel.add(this.messageTypeIconLabel);
            iconPanel.setBackground(BACKGROUND_COLOR);
            JPanel p = new JPanel(new BorderLayout());
            p.setBackground(BACKGROUND_COLOR);
            p.add((Component)iconPanel, "West");
            p.add(Box.createRigidArea(new Dimension(1, 22)), "East");
            p.add((Component)this.messageLabel.getContent(), "Center");
            p.add((Component)this.descriptionLabel, "North");
            p.setBorder(new EmptyBorder(2, 4, 2, 2));
            p.setBackground(BACKGROUND_COLOR);
            JPanel topPanel = new JPanel(new BorderLayout());
            topPanel.add((Component)p, "Center");
            topPanel.add((Component)new HorizontalLine(), "South");
            topPanel.add(Box.createRigidArea(new Dimension(1, 52)), "East");
            this.content = topPanel;
        }
        return this.content;
    }

    public final void setMessage(IBasicMessage message) {
        this.messageTypeIconLabel.setIcon(MessageTypeUi.getSmallIcon(message.getType()));
        this.messageLabel.setForeground(MessageTypeUi.getColor(message.getType()));
        this.messageLabel.setText(message.getText());
    }

    public final void setDescription(String description) {
        this.descriptionLabel.setText(description);
    }
}

