/*
 * Decompiled with CFR 0.152.
 */
package de.jave.javeplayer;

import de.jave.javeplayer.JavePlayer;
import de.jave.javeplayer.JavePlayerConfiguration;
import java.applet.AudioClip;
import java.awt.GridLayout;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.UIManager;

public class JavePlayerApplet
extends JApplet {
    private boolean initialized = false;
    private JavePlayer player;

    public String getAppletInfo() {
        return JavePlayer.TITLE;
    }

    public String[][] getParameterInfo() {
        String[][] info = new String[][]{{"FILE", "String", "Name of the JavE animation file to be loaded"}, {"AUTOSTART", "int", "Player will immediately start playing the animation if value is 1"}, {"LOOP", "int", "Player will loop infinite times if value is 1"}, {"CONTROLS", "int", "0: No controls 1: Just buttons (default) 2: All controls visible"}, {"SOUND", "String", "Name of a sound file (*.mid, *.au or *.wav) to be played at play()"}, {"SOUNDSTART", "String", "When to play the sound file: 'once', 'loop' or 'event'"}};
        return info;
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {}
        JavePlayerConfiguration controls = JavePlayerConfiguration.DEFAULT_CONTROLS;
        boolean loop = false;
        boolean autostart = false;
        String soundFile = null;
        int soundStart = 0;
        try {
            String s = this.getParameter("CONTROLS");
            if (s != null) {
                if (s.equals("0")) {
                    controls = JavePlayerConfiguration.NO_CONTROLS;
                } else if (s.equals("1")) {
                    controls = JavePlayerConfiguration.DEFAULT_CONTROLS;
                } else if (s.equals("2")) {
                    controls = JavePlayerConfiguration.ALL_CONTROLS;
                } else {
                    System.err.println("Error reading parameter 'CONTROLS': Must be 0, 1 or 2");
                }
            }
            if ((s = this.getParameter("LOOP")) != null && s.equals("1")) {
                loop = true;
            }
            if ((s = this.getParameter("SOUND")) != null && s.length() > 0) {
                soundFile = s;
            }
            if ((s = this.getParameter("SOUNDSTART")) != null) {
                if ((s = s.toLowerCase()).equals("once")) {
                    soundStart = 0;
                } else if (s.equals("loop")) {
                    soundStart = 1;
                } else if (s.equals("event")) {
                    soundStart = 2;
                } else {
                    System.err.println("Error reading parameter 'SOUNDSTART': Must be 'once' or 'loop' or 'event'");
                }
            }
            if ((s = this.getParameter("AUTOSTART")) != null && s.equals("1")) {
                autostart = true;
            }
        }
        catch (Exception e) {
            System.err.println("Error reading parameters: " + e);
        }
        this.player = new JavePlayer(controls, loop, autostart);
        if (soundFile != null) {
            AudioClip audio = this.getAudioClip(this.getDocumentBase(), soundFile);
            this.player.setAudioClip(audio);
            this.player.setAudioStart(soundStart);
        }
        this.getContentPane().setLayout(new GridLayout(1, 0, 0, 0));
        this.getContentPane().add(this.player);
        this.initialized = true;
    }

    public void start() {
        try {
            this.player.load(new URL(this.getCodeBase(), this.getParameter("FILE")));
            return;
        }
        catch (MalformedURLException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void stop() {
        this.player.stop();
    }
}

