/*
 * Decompiled with CFR 0.152.
 */
package de.jave.javeplayer;

import de.jave.javeplayer.JavePlayer;
import de.jave.javeplayer.JavePlayerResources;
import java.awt.Component;
import net.disy.commons.core.model.BooleanModel;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.action.SmartToggleAction;

public final class JavePlayerActions {
    private final SmartAction zoomOutAction;
    private final SmartAction zoomInAction;
    private final SmartAction stopAction;
    private final SmartAction pauseAction;
    private final SmartAction playAction;
    private final SmartAction forwardAction;
    private final SmartAction backwardAction;
    private final SmartToggleAction toggleLoopAction;

    public JavePlayerActions(final JavePlayer player, BooleanModel loop) {
        this.backwardAction = new SmartAction(this, JavePlayerResources.REVERSE_ICON){

            protected final void execute(Component parentComponent) {
                player.doPrev();
            }
        };
        this.backwardAction.setToolTipText("Backward");
        this.forwardAction = new SmartAction(this, JavePlayerResources.FORWARD_ICON){

            protected final void execute(Component parentComponent) {
                player.doNext();
            }
        };
        this.forwardAction.setToolTipText("Forward");
        this.playAction = new SmartAction(this, JavePlayerResources.PLAY_ICON){

            protected final void execute(Component parentComponent) {
                player.doPlay();
            }
        };
        this.playAction.setToolTipText("Play");
        this.pauseAction = new SmartAction(this, JavePlayerResources.PAUSE_ICON){

            protected final void execute(Component parentComponent) {
                player.doPause();
            }
        };
        this.pauseAction.setToolTipText("Pause");
        this.stopAction = new SmartAction(this, JavePlayerResources.STOP_ICON){

            protected final void execute(Component parentComponent) {
                player.doStop();
            }
        };
        this.stopAction.setToolTipText("Stop");
        this.zoomInAction = new SmartAction(this, JavePlayerResources.ZOOM_PLUS_ICON){

            protected final void execute(Component parentComponent) {
                player.doZoomIn();
            }
        };
        this.zoomInAction.setToolTipText("Zoom in");
        this.zoomOutAction = new SmartAction(this, JavePlayerResources.ZOOM_MINUS_ICON){

            protected final void execute(Component parentComponent) {
                player.doZoomOut();
            }
        };
        this.zoomOutAction.setToolTipText("Zoom out");
        this.toggleLoopAction = new SmartToggleAction(loop, JavePlayerResources.LOOP_ICON);
        this.toggleLoopAction.setToolTipText("Loop animation");
    }

    public final SmartAction getNextAction() {
        return this.forwardAction;
    }

    public final SmartAction getPauseAction() {
        return this.pauseAction;
    }

    public final SmartAction getPlayAction() {
        return this.playAction;
    }

    public final SmartAction getPrevAction() {
        return this.backwardAction;
    }

    public final SmartAction getStopAction() {
        return this.stopAction;
    }

    public final SmartAction getZoomInAction() {
        return this.zoomInAction;
    }

    public final SmartAction getZoomOutAction() {
        return this.zoomOutAction;
    }

    public final SmartToggleAction getToggleLoopAction() {
        return this.toggleLoopAction;
    }

    public final void setNavigationEnabled(boolean enabled) {
        this.stopAction.setEnabled(enabled);
        this.pauseAction.setEnabled(enabled);
        this.playAction.setEnabled(enabled);
        this.forwardAction.setEnabled(enabled);
        this.backwardAction.setEnabled(enabled);
        this.toggleLoopAction.setEnabled(enabled);
    }
}

