/*
 * Decompiled with CFR 0.152.
 */
package de.jave.javeplayer;

public final class AsciiPacker {
    protected AsciiPacker() {
    }

    public static final char[][] decode(String code) {
        if (code == null || code.length() < 4) {
            throw new RuntimeException("Unable to decode compressed ASCII:The compressed code doesn not seem to be valid!");
        }
        char algorithm = code.charAt(0);
        switch (algorithm) {
            case 'A': {
                return AsciiPacker.decodeA(code);
            }
            case 'B': {
                return AsciiPacker.decodeB(code);
            }
        }
        throw new RuntimeException("Unable to decode compressed ASCII: Algorithm '" + algorithm + "' not known by this program version! " + "Please download a new release.");
    }

    private static final char[][] decodeA(String code) {
        int length = code.length();
        int index = 1;
        int w = 0;
        ++index;
        char ch = code.charAt(1);
        while (ch >= '0' && ch <= '9') {
            w *= 10;
            w += ch - 48;
            ch = code.charAt(index++);
        }
        int h = 0;
        ch = code.charAt(index++);
        while (ch >= '0' && ch <= '9') {
            h *= 10;
            h += ch - 48;
            ch = code.charAt(index++);
        }
        char[][] chars = new char[h][w];
        int x = 0;
        int y = 0;
        while (index < length) {
            if ((ch = code.charAt(index++)) != '%') {
                chars[y][x++] = ch;
                continue;
            }
            if ((ch = code.charAt(index++)) == '%') {
                chars[y][x++] = 37;
                continue;
            }
            if (ch == '0') {
                for (int i = x; i < w; ++i) {
                    chars[y][x++] = 32;
                }
                ++y;
                x = 0;
                continue;
            }
            int count = ch - 48;
            ch = code.charAt(index++);
            while (ch >= '0' && ch <= '9') {
                count *= 10;
                count += ch - 48;
                ch = code.charAt(index++);
            }
            if (ch == '%') {
                ch = code.charAt(index++);
            }
            for (int i = 0; i < count; ++i) {
                chars[y][x++] = ch;
            }
        }
        while (x < w) {
            chars[y][x++] = 32;
        }
        for (int yy = y + 1; yy < h; ++yy) {
            for (int xx = 0; xx < w; ++xx) {
                chars[yy][xx] = 32;
            }
        }
        return chars;
    }

    private static final char[][] decodeB(String code) {
        int index = 1;
        int w = 0;
        ++index;
        char ch = code.charAt(1);
        while (ch >= '0' && ch <= '9') {
            w *= 10;
            w += ch - 48;
            ch = code.charAt(index++);
        }
        int h = 0;
        ch = code.charAt(index++);
        while (ch >= '0' && ch <= '9' && index < code.length()) {
            h *= 10;
            h += ch - 48;
            ch = code.charAt(index++);
        }
        char[][] chars = new char[h][w];
        int i = index;
        int l = code.length();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                chars[y][x] = i >= l ? 32 : code.charAt(i);
                ++i;
            }
        }
        return chars;
    }
}

