package vgp.tutor.vectorField;

import java.applet.Applet;
import java.awt.*;

import jv.object.*;
import jv.viewer.PvViewer;

/**
 * Tutorial applet on vector fields on planar grids and curved surfaces.
 * 
 * @see			jv.viewer.PvViewer
 * @author		Konrad Polthier
 * @version		18.09.99, 1.00 created (kp)
 */
public class PaVectorField extends Applet implements Runnable {
	/** frame if run standalone, null if run as applet */
	public		Frame				m_frame			= null;
	/** 3D-viewer window for graphics output and which is embedded into the applet */
	protected	PvViewer			m_viewer;
	/**
	 * Message string drawn in applet while loading. Modify string with drawMessage().
	 */
	private		String			m_drawString	= "Initializing ...";
	
	/** Interface of applet to inform about author, version, and copyright */
	public String getAppletInfo() {
		return "Name: "		+ this.getClass().getName()+ "\r\n" +
		       "Author: "		+ "Konrad Polthier" + "\r\n" +
		       "Version: "	+ "1.00" + "\r\n" +
				 "Straightest Vectorfields on Triangulations" + "\r\n";
	}

	/**
	 * Create thread that configures and initializes the viewer, loads system and user projects.
	 */
	public void init() {
		Thread thread = new Thread(this, "JavaView: inititialize applet");
		thread.setPriority(Thread.NORM_PRIORITY);
		thread.start();
	}
	/**
	 * Configure and initialize the viewer, load system and user projects.
	 * One of the user projects may be selected here.
	 */
	public void run() {
		drawMessage("Loading viewer ...");
		// Create viewer for viewing 3d geometries
		m_viewer = new PvViewer(this, m_frame);

		drawMessage("Loading vector field project ...");
		// Create and load a project
		PjVectorField proj = new PjVectorField();

		m_viewer.addProject(proj);
		m_viewer.selectProject(proj);

		// Get 3d display from viewer and add it to applet
		setLayout(new BorderLayout());
		add((Component)m_viewer.getDisplay(), BorderLayout.CENTER);
		if ("Show".equals(m_viewer.getParameter("ProjectPanel")))
			add(m_viewer.getPanel(PsViewerIf.PROJECT), BorderLayout.EAST);
		validate();

		// Choose initial panel in control window (must press F1 inside the applet)
		m_viewer.showPanel(PsViewerIf.MATERIAL);

		// Explicitly start the applet
		startFromThread();
	}
	/**
	 * Standalone application support. The main() method acts as the applet's
	 * entry point when it is run as a standalone application. It is ignored
	 * if the applet is run from within an HTML page.
	 */
	public static void main(String args[]) {
		PaVectorField va	= new PaVectorField();
		// Create toplevel window of application containing the applet
		Frame frame	= new jv.object.PsMainFrame(va, args);
		frame.pack();
		va.m_frame = frame;
		va.init();
		va.start();
		frame.setBounds(new Rectangle(420, 5, 640, 550));
		frame.setVisible(true);
	}
	
	/** Set message string to be drawn in apllet while loading. */
	private void drawMessage(String message) {
		m_drawString = message;
		repaint();
	}
	/** Print info while initializing applet and viewer. */
	public void paint(Graphics g) {
		g.setColor(Color.blue);
		g.drawString(PsConfig.getProgram()+" v."+PsConfig.getVersion(), 20, 40);
		g.drawString(m_drawString, 20, 60);
	}
	/**
	 * Does clean-up when applet is destroyed by the browser.
	 * Here we just close and dispose all our control windows.
	 */
	public void destroy()			{ if (m_viewer != null) m_viewer.destroy(); }

	/** Stop viewer, e.g. stop animation if requested */
	public void stop()				{ if (m_viewer != null) m_viewer.stop(); }
	/**
	 * Start viewer, e.g. start animation if requested.
	 * Necessary, if initialization is done in a separate thread. In this case the original
	 * applet.start() has no effect.
	 */
	public void startFromThread()	{ if (m_viewer!=null) m_viewer.start(); }
}
