package vgp.tutor.parm;

import jv.object.PsConfig;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PjProject_IP;

/**
 * Info panel for PjParmSurface with panels for parametrized surfaces.
 * 
 * @see			jvx.surface.PgParmSurface_CP
 * @author		Konrad Polthier
 * @version		03.01.02, 1.10 revised (kp) Use control panel of PgParmSurface.<br>
 *					27.08.98, 1.00 created (kp) from PgParmSurface_IP.
 */
public class PjParmSurface_IP extends PjProject_IP {
	protected	PjParmSurface			m_pjParmSurface;

	public PjParmSurface_IP() {
		super();
		if (getClass() == PjParmSurface_IP.class)
			init();
	}
	public void init() {
		super.init();
		addTitle("");
	}
	public void setParent(PsUpdateIf parent) {
		super.setParent(parent);
		m_pjParmSurface = (PjParmSurface)parent;
		setTitle(PsConfig.getMessage(28003)+" "+m_pjParmSurface.getName());
		// Create an info panel of the workshop by ourself
		PsPanel cp = m_pjParmSurface.m_parmSurface.newInspector(PsPanel.CONFIG_EXT);
		cp.setBorderType(PsPanel.BORDER_NONE);
		add(cp);
	}
}
