package vgp.tutor.ode;

import java.applet.Applet;
import java.awt.*;

import jv.object.*;
import jv.project.PvDisplayIf;
import jv.viewer.PvViewer;

/**
 * Applet studies ODE's
 * 
 * @see			jv.viewer.PvViewer
 * @author		Konrad Polthier
 * @version		21.03.04, 1.10 revised (kp) Menubar added to application.<br>
 *					06.10.98, 1.01 revised (kp) Modified according to new vgp structure.<br>
 *					06.10.98, 1.00 created (kp)
 */
public class PaExprOde extends Applet {
	/** frame if run standalone, null if run as applet. */
	public		Frame				m_frame			= null;
	/** 3D-viewer window for graphics output and which is embedded into the applet. */
	protected	PvViewer			m_viewer;

	/** Interface of applet to inform about author, version, and copyright. */
	public String getAppletInfo() {
		return "Name: "		+ this.getClass().getName()+ "\r\n" +
				 "Author: "		+ "Konrad Polthier" + "\r\n" +
				 "Version: "	+ "1.01" + "\r\n" +
				 "Applet studies ordinary differential equations" + "\r\n";
	}

	/**
	 * Configure and initialize the viewer, load system and user projects.
	 * One of the user projects must be selected here.
	 */
	public void init() {
		// Create viewer for viewing 3d geometries if not already done by application#main().
		if (m_viewer == null)
			m_viewer = new PvViewer(this, m_frame);

		// Create and load a project
		PjExprOde pjExpr = new PjExprOde();
		m_viewer.addProject(pjExpr);
		m_viewer.selectProject(pjExpr);

		// Get 3d display from viewer and add it to applet
		setLayout(new BorderLayout());
		PvDisplayIf disp = m_viewer.getDisplay();

		add((Component)disp, BorderLayout.CENTER);
		add(m_viewer.getPanel(PsViewerIf.PROJECT), BorderLayout.EAST);
		validate();
	}
	/**
	 * Standalone application support. The main() method acts as the applet's
	 * entry point when it is run as a standalone application. It is ignored
	 * if the applet is run from within an HTML page.
	 */
	public static void main(String args[]) {
		PaExprOde va	= new PaExprOde();
		// Create toplevel window of application containing the applet
		Frame frame	= new jv.object.PsMainFrame(va, args);
		va.m_frame	= frame;
		va.m_viewer	= new PvViewer(va, frame);
		
		// Add the JavaView menu bar if not suppressed by commandline argument.
		String parmMenuBar	= va.m_viewer.getParameter("menuBar");
		if (parmMenuBar==null || !parmMenuBar.equalsIgnoreCase("hide"))
			frame.setMenuBar(va.m_viewer.newMenuBar(frame));
		
		frame.pack();
		
		va.init();
		va.start();
		frame.setBounds(new Rectangle(5, 5, 800, 550));
		frame.setVisible(true);
	}
	
	/** Print info while initializing applet and viewer. */
	public void paint(Graphics g) {
		g.setColor(Color.blue);
		g.drawString("Geometry Browser, Version "+PsConfig.getVersion(), 20, 40);
		g.drawString("Loading Projects .....", 20, 60);
	}

	/**
	 * Does clean-up when applet is destroyed by the browser.
	 * Here we just close and dispose all our control windows.
	 */
	public void destroy()	{ m_viewer.destroy(); }

	/** Start viewer, e.g. start animation if requested */
	public void start()		{ m_viewer.start(); }

	/** Stop viewer, e.g. stop animation if requested */
	public void stop()		{ m_viewer.stop(); }
}
