package vgp.tutor.model;

import java.awt.*;

import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PjProject_IP;

/**
 * Info panel of PjModel with a textfield to load a JavaView built-in model.
 * 
 * @author		Konrad Polthier
 * @version		15.01.00, 1.00 revised (kp)<br>
 *					15.01.00, 1.00 revised (kp)
 */
public class PjModel_IP extends PjProject_IP {
	protected	PjModel					m_pjModel;
	protected	Panel						m_pInfo;
	
	public PjModel_IP() {
		super();
		if (getClass() == PjModel_IP.class)
			init();
	}
	
	// Initialization.
	public void init() {
		super.init();
		addTitle("Load Model from File or URL");

		// start of Model load panel
		m_pInfo = new Panel();
		m_pInfo.setLayout(new BorderLayout());
		TextArea textArea = new TextArea("Sample inclusion of the small info panel\n"+
													"of project PjImportModel. Type the full\n"+
													"name of a local geometry file, or the name\n"+
													"relative to the current code base, or the full URL.");
		textArea.setEditable(false);
		m_pInfo.add(textArea, "North");
		add(m_pInfo);
	}
	public void setParent(PsUpdateIf parent) {
		super.setParent(parent);

		m_pjModel = (PjModel)parent;
		m_pInfo.add(m_pjModel.m_import.getInfoPanel(), "Center");
		m_pInfo.validate();
	}
	/**
	 * Here we arrive from outside world of this panel, e.g. if
	 * parent has changed somewhere else.
	 */
	public boolean update(Object anObject) {
		if (m_pjModel==null) {
			if (PsDebug.WARNING) PsDebug.warning("missing parent, setParent not called");
			return false;
		}
		if (anObject == m_pjModel) {
			return true;
		}
		return super.update(anObject);
	}
}
