/*
 * Decompiled with CFR 0.152.
 */
package org.joy;

import java.io.File;
import java.io.FileOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import org.joy.JoyInterface;

public class Joy {
    private static boolean nativeLibLoaded = false;

    public static synchronized List<Info> listDevices() throws UnsupportedOperationException {
        if (!nativeLibLoaded) {
            Joy.init();
        }
        try {
            ArrayList<Info> devices = new ArrayList<Info>();
            int numDevices = JoyInterface.getMaxDevices();
            int id = 0;
            while (id < numDevices) {
                if (JoyInterface.isConnected(id)) {
                    Info info = new Info(id);
                    devices.add(info);
                }
                ++id;
            }
            return devices;
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException("Joy: Could not access Native Library: " + e.getMessage(), e);
        }
    }

    private static synchronized void init() throws UnsupportedOperationException {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            /*
             * Unable to fully structure code
             */
            @Override
            public Void run() {
                try {
                    block6: {
                        libName = Joy.access$1();
                        try {
                            System.loadLibrary(libName);
                            break block6;
                        }
                        catch (Throwable e) {
                            libFileName = System.mapLibraryName(libName);
                            libResource = "/org/joy/nativelibs/" + libFileName;
                            resInput = this.getClass().getResourceAsStream(libResource);
                            if (resInput == null) {
                                throw new UnsupportedOperationException("Unsupported Operating System");
                            }
                            tempLibFile = File.createTempFile(libFileName.substring(0, libFileName.lastIndexOf(".")), libFileName.substring(libFileName.lastIndexOf(".")));
                            tempLibFile.deleteOnExit();
                            tempOutput = new FileOutputStream(tempLibFile);
                            buffer = new byte[16384];
                            ** while ((bytes = resInput.read((byte[])buffer)) != -1)
                        }
lbl-1000:
                        // 1 sources

                        {
                            tempOutput.write(buffer, 0, bytes);
                            continue;
                        }
lbl19:
                        // 1 sources

                        tempOutput.close();
                        resInput.close();
                        System.load(tempLibFile.getAbsolutePath());
                    }
                    Joy.access$2(true);
                    return null;
                }
                catch (Throwable e) {
                    throw new UnsupportedOperationException("Joy: Could not load Native Library: " + e.getMessage(), e);
                }
            }
        });
    }

    private static String nativeLibName() {
        String arch = System.getProperty("os.arch");
        if (arch == null || arch.indexOf("64") < 0) {
            return "JoyInterface32";
        }
        return "JoyInterface64";
    }

    private static String printIntArray(int[] arr) {
        String res = "" + arr[0];
        int i = 1;
        while (i < arr.length) {
            res = String.valueOf(res) + ", " + arr[i];
            ++i;
        }
        return res;
    }

    static /* synthetic */ String access$1() {
        return Joy.nativeLibName();
    }

    static /* synthetic */ void access$2(boolean bl) {
        nativeLibLoaded = bl;
    }

    public static class Info {
        public int id;
        public String name = "Undefined";
        public boolean pov;
        public int buttons;
        public int axes;
        public int[] axesMinValues = new int[6];
        public int[] axesMaxValues = new int[6];
        private State state;

        private Info(int id) {
            this.id = id;
            JoyInterface.updateInfo(id, this);
        }

        public State getState() {
            if (this.state == null) {
                this.state = new State(this.id);
            }
            this.state.update();
            return this.state;
        }

        public String toString() {
            return this.id + ": " + this.name;
        }

        public String description() {
            return this.id + ": " + this.name + "\n" + "POV: " + (this.pov ? "yes" : "no") + ", Axes: " + this.axes + ", Buttons: " + this.buttons + "\n" + "Mins: " + Joy.printIntArray(this.axesMinValues) + ", Maxes: " + Joy.printIntArray(this.axesMaxValues);
        }
    }

    static class State {
        private int id;
        private int[] data = new int[8];

        private State(int id) {
            this.id = id;
        }

        public boolean update() {
            return JoyInterface.updateState(this.id, this);
        }

        public int getPOV() {
            return this.data[0];
        }

        public int getButtons() {
            return this.data[1];
        }

        public int getAxis(int axis) {
            assert (axis >= 0 && axis <= 5);
            return this.data[2 + axis];
        }

        public String toString() {
            return "State: " + Joy.printIntArray(this.data);
        }
    }
}

