/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.pc.cartridge;

import java.awt.Dimension;
import java.io.File;
import java.security.AccessControlException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.javatari.atari.cartridge.Cartridge;
import org.javatari.parameters.Parameters;
import org.javatari.pc.cartridge.FileServiceROMChooser;
import org.javatari.pc.cartridge.ROMLoader;

public final class FileROMChooser {
    private static JFileChooser chooser;
    private static File lastFileChosen;

    public static Cartridge chooseFile() {
        if (lastFileChosen == null) {
            lastFileChosen = new File(Parameters.LAST_ROM_FILE_CHOSEN);
        }
        try {
            if (chooser == null) {
                chooser = new JFileChooser();
                chooser.setFileFilter(new FileNameExtensionFilter("ROM files (.bin .rom .a26 .zip)", ROMLoader.VALID_FILE_EXTENSIONS));
                chooser.setPreferredSize(new Dimension(580, 400));
            }
            chooser.setSelectedFile(lastFileChosen);
            int res = chooser.showOpenDialog(null);
            if (res != 0) {
                return null;
            }
        }
        catch (AccessControlException ex) {
            return FileServiceROMChooser.chooseFile();
        }
        lastFileChosen = chooser.getSelectedFile();
        Parameters.LAST_ROM_FILE_CHOSEN = lastFileChosen.toString();
        Parameters.savePreferences();
        return ROMLoader.load(lastFileChosen);
    }
}

