/*
 * Decompiled with CFR 0.152.
 */
package org.javatari.atari.cartridge.formats;

import org.javatari.atari.cartridge.Cartridge;
import org.javatari.atari.cartridge.CartridgeFormat;
import org.javatari.atari.cartridge.CartridgeFormatOption;
import org.javatari.atari.cartridge.ROM;
import org.javatari.atari.cartridge.formats.CartridgeBanked;

public final class Cartridge8K_E0
extends CartridgeBanked {
    private int slice0AddressOffset = 0;
    private int slice1AddressOffset = 0;
    private int slice2AddressOffset = 0;
    private static final int SIZE = 8192;
    public static final CartridgeFormat FORMAT = new CartridgeFormat("E0", "8K Parker Bros."){
        private static final long serialVersionUID = 1L;

        @Override
        public Cartridge createCartridge(ROM rom) {
            return new Cartridge8K_E0(rom, null);
        }

        @Override
        public CartridgeFormatOption getOption(ROM rom) {
            if (rom.content.length != 8192) {
                return null;
            }
            return new CartridgeFormatOption(102, this, rom);
        }
    };
    public static final long serialVersionUID = 1L;

    private Cartridge8K_E0(ROM rom) {
        super(rom, FORMAT);
    }

    @Override
    public byte readByte(int address) {
        this.maskAddress(address);
        if (this.maskedAddress < 1024) {
            return this.bytes[this.slice0AddressOffset + this.maskedAddress];
        }
        if (this.maskedAddress < 2048) {
            return this.bytes[this.slice1AddressOffset + this.maskedAddress - 1024];
        }
        if (this.maskedAddress < 3072) {
            return this.bytes[this.slice2AddressOffset + this.maskedAddress - 2048];
        }
        return this.bytes[4096 + this.maskedAddress];
    }

    @Override
    protected void performBankSwitchOnMaskedAddress() {
        if (this.maskedAddress < 4064 || this.maskedAddress > 4087) {
            return;
        }
        if (this.maskedAddress <= 4071) {
            this.slice0AddressOffset = (this.maskedAddress - 4064) * 1024;
        } else if (this.maskedAddress <= 4079) {
            this.slice1AddressOffset = (this.maskedAddress - 4072) * 1024;
        } else if (this.maskedAddress <= 4087) {
            this.slice2AddressOffset = (this.maskedAddress - 4080) * 1024;
        }
    }

    /* synthetic */ Cartridge8K_E0(ROM rOM, Cartridge8K_E0 cartridge8K_E0) {
        this(rOM);
    }
}

