
package ibxm;

import java.io.*;
import javax.sound.sampled.*;

public class Player {
	public static void main( String[] args ) throws Exception {
		FileInputStream file_input_stream;
		DataInputStream data_input_stream;
		AudioFormat output_format;
		SourceDataLine output_line;
		byte[] xm_header, s3m_header, mod_header, output_buffer;
		int song_duration, frames;
		file_input_stream = new FileInputStream( args[ 0 ] );
		data_input_stream = new DataInputStream( file_input_stream );
		Module module;
		IBXM ibxm;
		module = null;
		xm_header = new byte[ 60 ];
		data_input_stream.readFully( xm_header );
		if( FastTracker2.is_xm( xm_header ) ) {
			module = FastTracker2.load_xm( xm_header, data_input_stream );
		} else {
			s3m_header = new byte[ 96 ];
			System.arraycopy( xm_header, 0, s3m_header, 0, 60 );
			data_input_stream.readFully( s3m_header, 60, 36 );
			if( ScreamTracker3.is_s3m( s3m_header ) ) {
				module = ScreamTracker3.load_s3m( s3m_header, data_input_stream );
			} else {
				mod_header = new byte[ 1084 ];
				System.arraycopy( s3m_header, 0, mod_header, 0, 96 );
				data_input_stream.readFully( mod_header, 96, 988 );
				module = ProTracker.load_mod( mod_header, data_input_stream );
			}
		}
		data_input_stream.close();
		ibxm = new IBXM( 48000 );
		ibxm.set_module( module );
		song_duration = ibxm.calculate_song_duration();
		output_format = new AudioFormat( 48000, 16, 2, true, false );
		output_line = AudioSystem.getSourceDataLine( output_format );
		output_buffer = new byte[ 1024 * 4 ];
		output_line.open();
		output_line.start();
		while( song_duration > 0 ) {
			frames = 1024;
			if( frames > song_duration ) {
				frames = song_duration;
			}
			ibxm.get_audio( output_buffer, frames );
			output_line.write( output_buffer, 0, frames * 4 );
			song_duration -= frames;
		}
		output_line.drain();
		output_line.close();
	}
}

