// This script is executed during initialization of each level.
// It contains some commonly used stuff to simplify the script-writing
// within the gamecontrol node of the levels.


// The player's ship as global variable, so it can be accessed directly.
var player = gameControl.getPlayer();


/**
 * @return A random number inside the interval [0..max].
 */
function random(max) {
	return Math.round(max*Math.random());
}

/**
 * @return The shuffled array.
 */
function shuffle(array) {
	for(var j, x, i = array.length; i; j = parseInt(Math.random() * i), x = array[--i], array[i] = array[j], array[j] = x);
    return array;
}

/**
 * Creates a new LandOnPlatform objective to the game control.
 * @param platformId The ID of the platform to land on.
 */
function addLandOnPlatformObjective(platformId) {
	var objective = new Packages.moagg.game.control.objective.LandOnPlatform();
	objective.setPlatform(gameControl.getObjectById(platformId));
	gameControl.addObjective(objective);
}

/**
 * Creates a new BringCrateToPlatform objective to the game control.
 * @param crateId The ID of the crate.
 * @param platformId The ID of the platform to bring the crate to.
 */
function addBringCrateToPlatformObjective(crateId, platformId) {
	var objective = new Packages.moagg.game.control.objective.BringCrateToPlatform();
	objective.setCrate(gameControl.getObjectById(crateId));
	objective.setPlatform(gameControl.getObjectById(platformId));
  	gameControl.addObjective(objective);
}

/**
 * Creates a new DestroyTarget objective to the game control.
 * @param objectId The ID of the object that must be destroyed.
 */
function addDestroyTargetObjective(objectId) {
	var objective = new Packages.moagg.game.control.objective.DestroyTarget();
	objective.setObject(gameControl.getObjectById(objectId));
  	gameControl.addObjective(objective);
}

/**
 * @return A new GTGE Timer object with the given initial delay.
 */
function createTimer(delay) {
	return new Packages.com.golden.gamedev.object.Timer(delay);
}
