/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.engine.jogl;

import com.golden.gamedev.engine.graphics.NullGraphics;
import com.golden.gamedev.engine.jogl.Texture;
import com.golden.gamedev.engine.jogl.TextureLoader;
import com.golden.gamedev.object.GameFont;
import com.golden.gamedev.object.font.AdvanceBitmapFont;
import com.golden.gamedev.util.FontUtil;
import com.golden.gamedev.util.ImageUtil;
import com.golden.gamedev.util.Utility;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.WeakHashMap;
import net.java.games.jogl.GL;
import net.java.games.jogl.util.BufferUtils;

public class JOGLGraphics
extends NullGraphics {
    private static double[] a = new double[9];
    private static FloatBuffer b = BufferUtils.newFloatBuffer((int)16);
    private static IntBuffer c = BufferUtils.newIntBuffer((int)16);
    private GL d;
    private static final Rectangle e = new Rectangle();
    private TextureLoader f;
    private Color h = Color.BLACK;
    private Color i = Color.BLACK;
    private Composite j;
    private Font k;
    private WeakHashMap l;
    private Graphics2D g;
    private int n;
    private Rectangle o;

    public JOGLGraphics(GL gL) {
        this.d = gL;
        this.f = new TextureLoader(gL);
        this.l = new WeakHashMap();
    }

    public GL getGL() {
        return this.d;
    }

    public TextureLoader getTextureLoader() {
        return this.f;
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        this.ba();
        this.d.glPushMatrix();
        Texture texture = this.f.getTexture((BufferedImage)image);
        texture.bind(this.d);
        this.d.glTranslatef((float)n, (float)n2, 0.0f);
        this.d.glBegin(7);
        this.d.glTexCoord2f(0.0f, 0.0f);
        this.d.glVertex2f(0.0f, 0.0f);
        this.d.glTexCoord2f(0.0f, texture.getHeight());
        this.d.glVertex2f(0.0f, (float)texture.getImageHeight());
        this.d.glTexCoord2f(texture.getWidth(), texture.getHeight());
        this.d.glVertex2f((float)texture.getImageWidth(), (float)texture.getImageHeight());
        this.d.glTexCoord2f(texture.getWidth(), 0.0f);
        this.d.glVertex2f((float)texture.getImageWidth(), 0.0f);
        this.d.glEnd();
        this.d.glPopMatrix();
        this.ca();
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        this.ba();
        this.d.glPushMatrix();
        Texture texture = this.f.getTexture((BufferedImage)image);
        texture.bind(this.d);
        this.d.glTranslatef((float)n, (float)n2, 0.0f);
        this.d.glBegin(7);
        this.d.glTexCoord2f(0.0f, 0.0f);
        this.d.glVertex2f(0.0f, 0.0f);
        this.d.glTexCoord2f(0.0f, texture.getHeight());
        this.d.glVertex2f(0.0f, (float)n4);
        this.d.glTexCoord2f(texture.getWidth(), texture.getHeight());
        this.d.glVertex2f((float)n3, (float)n4);
        this.d.glTexCoord2f(texture.getWidth(), 0.0f);
        this.d.glVertex2f((float)n3, 0.0f);
        this.d.glEnd();
        this.d.glPopMatrix();
        this.ca();
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        this.ba();
        Texture texture = this.f.getTexture((BufferedImage)image);
        texture.bind(this.d);
        float f = (float)n5 / (float)texture.getTextureWidth();
        float f2 = (float)n7 / (float)texture.getTextureWidth();
        float f3 = (float)n6 / (float)texture.getTextureHeight();
        float f4 = (float)n8 / (float)texture.getTextureHeight();
        this.d.glBegin(7);
        this.d.glTexCoord2f(f, f3);
        this.d.glVertex2f((float)n, (float)n2);
        this.d.glTexCoord2f(f2, f3);
        this.d.glVertex2f((float)n3, (float)n2);
        this.d.glTexCoord2f(f2, f4);
        this.d.glVertex2f((float)n3, (float)n4);
        this.d.glTexCoord2f(f, f4);
        this.d.glVertex2f((float)n, (float)n4);
        this.d.glEnd();
        this.ca();
        return true;
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        affineTransform.getMatrix(a);
        b.rewind();
        b.put((float)a[0]).put((float)a[1]).put(0.0f).put(0.0f);
        b.put((float)a[2]).put((float)a[3]).put(0.0f).put(0.0f);
        b.put(0.0f).put(0.0f).put(1.0f).put(0.0f);
        b.put((float)a[4]).put((float)a[5]).put(0.0f).put(1.0f);
        b.rewind();
        this.d.glPushMatrix();
        this.d.glMultMatrixf(b);
        this.drawImage(image, 0, 0, null);
        this.d.glPopMatrix();
        return true;
    }

    public void drawString(String string, int n, int n2) {
        this.ea().drawString((Graphics2D)this, string, n, n2 + this.n);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.da(n, n2, n3, n4, 7, this.h);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.da(n, n2, n3, n4, 2, this.h);
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.da(n, n2, n3, n4, 7, this.i);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.d.glDisable(3553);
        this.d.glColor4f((float)this.h.getRed() / 255.0f, (float)this.h.getGreen() / 255.0f, (float)this.h.getBlue() / 255.0f, (float)this.h.getAlpha() / 255.0f);
        this.d.glLineWidth(1.0f);
        this.d.glBegin(1);
        this.d.glVertex2f((float)n, (float)n2);
        this.d.glVertex2f((float)n3, (float)n4);
        this.d.glEnd();
        this.d.glColor3f(1.0f, 1.0f, 1.0f);
        this.d.glEnable(3553);
    }

    public void setColor(Color color) {
        this.h = color;
    }

    public Color getColor() {
        return this.h;
    }

    public void setBackground(Color color) {
        this.i = color;
    }

    public Color getBackground() {
        return this.i;
    }

    public void setComposite(Composite composite) {
        this.j = composite;
    }

    public Composite getComposite() {
        return this.j;
    }

    public Font getFont() {
        if (this.k == null) {
            this.setFont(new Font("Dialog", 0, 12));
        }
        return this.k;
    }

    public void setFont(Font font) {
        if (font != null) {
            this.k = font;
            FontMetrics fontMetrics = this.getFontMetrics(font);
            this.n = fontMetrics.getDescent() - fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent() - fontMetrics.getLeading();
        }
    }

    public FontMetrics getFontMetrics() {
        JOGLGraphics jOGLGraphics = this;
        return jOGLGraphics.getFontMetrics(jOGLGraphics.getFont());
    }

    public FontMetrics getFontMetrics(Font font) {
        if (this.g == null) {
            this.g = ImageUtil.createImage((int)1, (int)1).createGraphics();
        }
        return this.g.getFontMetrics(font);
    }

    public void dispose() {
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.setClip(n, n2, n3, n4);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.d.glGetIntegerv(2978, c);
        this.d.glEnable(3089);
        this.d.glScissor(n, c.get(3) - n2 - n4, n3, n4);
        if (this.o == null) {
            this.o = e;
        }
        this.o.setBounds(n, n2, n3, n4);
    }

    public Shape getClip() {
        return this.o;
    }

    public void setClip(Shape shape) {
        this.o = (Rectangle)shape;
        if (this.o == null) {
            this.d.glDisable(3089);
            return;
        }
        JOGLGraphics jOGLGraphics = this;
        jOGLGraphics.setClip(jOGLGraphics.o.x, this.o.y, this.o.width, this.o.height);
    }

    private void ba() {
        if (this.j != null) {
            try {
                this.d.glColor4f(1.0f, 1.0f, 1.0f, ((AlphaComposite)this.j).getAlpha());
                return;
            }
            catch (ClassCastException classCastException) {}
        }
    }

    private void ca() {
        if (this.j != null) {
            this.d.glColor3f(1.0f, 1.0f, 1.0f);
        }
    }

    private void da(int n, int n2, int n3, int n4, int n5, Color color) {
        this.d.glDisable(3553);
        this.d.glColor4f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
        this.d.glLineWidth(1.0f);
        this.d.glBegin(n5);
        this.d.glVertex2f((float)n, (float)n2);
        this.d.glVertex2f((float)(n + n3), (float)n2);
        this.d.glVertex2f((float)(n + n3), (float)(n2 + n4));
        this.d.glVertex2f((float)n, (float)(n2 + n4));
        this.d.glEnd();
        this.d.glColor3f(1.0f, 1.0f, 1.0f);
        this.d.glEnable(3553);
    }

    private GameFont ea() {
        Font font = this.getFont();
        GameFont gameFont = (GameFont)this.l.get(font);
        if (gameFont == null) {
            BufferedImage bufferedImage = FontUtil.createBitmapFont((Font)font, (Color)Color.BLACK);
            int n = bufferedImage.getRGB(0, 0);
            int[] nArray = new int[100];
            int n2 = 0;
            int n3 = 0;
            int n4 = 1;
            while (n4 < bufferedImage.getWidth()) {
                if (bufferedImage.getRGB(n4, 0) == n) {
                    nArray[n2++] = n4 - n3;
                    n3 = n4;
                    if (n2 >= nArray.length) {
                        nArray = (int[])Utility.expand((Object)nArray, (int)50);
                    }
                }
                ++n4;
            }
            BufferedImage[] bufferedImageArray = new BufferedImage[n2];
            int n5 = bufferedImage.getHeight() - 1;
            int n6 = 0;
            int n7 = 0;
            while (n7 < bufferedImageArray.length) {
                bufferedImageArray[n7] = bufferedImage.getSubimage(n6, 1, nArray[n7], n5);
                n6 += nArray[n7];
                ++n7;
            }
            gameFont = new AdvanceBitmapFont(bufferedImageArray);
            this.l.put(font, gameFont);
        }
        return gameFont;
    }
}

