/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.util;

import com.golden.gamedev.util.Utility;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;

public class FileUtil {
    public static boolean fileWrite(String[] stringArray, File file) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            PrintWriter printWriter = new PrintWriter(bufferedWriter);
            int n = 0;
            while (n < stringArray.length) {
                printWriter.println(stringArray[n]);
                ++n;
            }
            printWriter.close();
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public static String[] fileRead(File file) {
        try {
            String string;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            ArrayList<String> arrayList = new ArrayList<String>(50);
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
            bufferedReader.close();
            return Utility.compactStrings(arrayList.toArray(new String[0]));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static String[] fileRead(InputStream inputStream) {
        try {
            String string;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            ArrayList<String> arrayList = new ArrayList<String>(50);
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
            bufferedReader.close();
            return Utility.compactStrings(arrayList.toArray(new String[0]));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static String[] fileRead(URL uRL) {
        try {
            return FileUtil.fileRead(uRL.openStream());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static File setExtension(File file, String string) {
        String string2 = file.getAbsolutePath();
        int n = string2.lastIndexOf(46);
        if (n < 0) {
            return new File(string2 + "." + string);
        }
        return new File(string2.substring(0, n) + "." + string);
    }

    public static String getExtension(File file) {
        return FileUtil.getExtension(file.getName());
    }

    public static String getExtension(String string) {
        int n = FileUtil.n(string);
        String string2 = n <= 0 ? string : string.substring(n + 1);
        String string3 = "";
        int n2 = string2.lastIndexOf(46);
        if (n2 > 0 && n2 < string2.length() - 1) {
            string3 = string2.substring(n2 + 1);
        }
        return string3;
    }

    public static String getName(File file) {
        return FileUtil.getName(file.getName());
    }

    public static String getName(String string) {
        int n = FileUtil.n(string);
        String string2 = n <= 0 ? string : string.substring(n + 1);
        String string3 = string2;
        int n2 = string2.lastIndexOf(46);
        if (n2 > 0 && n2 < string2.length()) {
            string3 = string2.substring(0, n2);
        }
        return string3;
    }

    public static String getPath(File file) {
        try {
            return FileUtil.getPath(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static String getPath(String string) {
        String string2 = "";
        int n = FileUtil.n(string);
        if (n > 0) {
            string2 = string.substring(0, n + 1);
        }
        return string2;
    }

    public static String getPathName(File file) {
        try {
            return FileUtil.getPathName(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static String getPathName(String string) {
        String string2 = "";
        int n = FileUtil.n(string);
        if (n > 0) {
            string2 = string.substring(0, n + 1);
        } else {
            n = 0;
        }
        String string3 = n <= 0 ? string : string.substring(n + 1);
        String string4 = string3;
        int n2 = string3.lastIndexOf(46);
        if (n2 > 0 && n2 < string3.length()) {
            string4 = string3.substring(0, n2);
        }
        return string2 + string4;
    }

    private static int n(String string) {
        int n = string.lastIndexOf(47);
        if (n < 0) {
            n = string.lastIndexOf(File.separatorChar);
        }
        return n;
    }
}

