/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object.collision;

import com.golden.gamedev.object.CollisionManager;
import com.golden.gamedev.object.Sprite;
import com.golden.gamedev.object.collision.CollisionGroup;
import com.golden.gamedev.object.collision.CollisionRect;
import com.golden.gamedev.object.collision.CollisionShape;
import com.golden.gamedev.object.collision.PreciseCollisionGroup$TrackRect;

public abstract class PreciseCollisionGroup
extends CollisionGroup {
    private final PreciseCollisionGroup$TrackRect a = new PreciseCollisionGroup$TrackRect(this);
    private final PreciseCollisionGroup$TrackRect b = new PreciseCollisionGroup$TrackRect(this);

    public boolean isCollide(Sprite sprite, Sprite sprite2, CollisionShape collisionShape, CollisionShape collisionShape2) {
        if (collisionShape.intersects(collisionShape2)) {
            this.sprite1 = sprite;
            this.sprite2 = sprite2;
            this.collisionSide = 0;
            double d = sprite.getOldX();
            double d2 = sprite.getOldY();
            double d3 = sprite2.getOldX();
            double d4 = sprite2.getOldY();
            double d5 = sprite.getX() - d;
            double d6 = sprite.getY() - d2;
            double d7 = sprite2.getX() - d3;
            double d8 = sprite2.getY() - d4;
            this.a.setBounds(collisionShape.getX(), collisionShape.getY(), collisionShape.getWidth(), collisionShape.getHeight());
            this.b.setBounds(collisionShape2.getX(), collisionShape2.getY(), collisionShape2.getWidth(), collisionShape2.getHeight());
            this.a.move(-d5, -d6);
            this.b.move(-d7, -d8);
            double d9 = Math.max(Math.max(Math.abs(d5), Math.abs(d6)), Math.max(Math.abs(d7), Math.abs(d8)));
            this.a.setCollisionStep(d5 / d9, d6 / d9);
            this.b.setCollisionStep(d7 / d9, d8 / d9);
            d9 += 1.0;
            int n = 0;
            while ((double)n <= d9) {
                if (this.a.intersects(this.b)) {
                    boolean bl = true;
                    if (this.pixelPerfectCollision && !CollisionManager.isPixelCollide(this.a.getX(), this.a.getY(), sprite.getImage(), this.b.getX(), this.b.getY(), sprite2.getImage())) {
                        bl = false;
                    }
                    if (bl) {
                        this.a.prevTrack();
                        this.b.prevTrack();
                        this.collisionX1 = d + this.a.dx;
                        this.collisionY1 = d2 + this.a.dy;
                        this.collisionX2 = d3 + this.b.dx;
                        this.collisionY2 = d4 + this.b.dy;
                        if (this.collisionY1 + (double)this.a.height <= this.collisionY2) {
                            this.collisionSide = 8;
                        } else if (this.collisionY2 + (double)this.b.height <= this.collisionY1) {
                            this.collisionSide = 4;
                        } else if (this.collisionX1 + (double)this.a.width <= this.collisionX2) {
                            this.collisionSide = 2;
                        } else if (this.collisionX2 + (double)this.b.width <= this.collisionX1) {
                            this.collisionSide = 1;
                        } else {
                            CollisionRect collisionRect = CollisionManager.getIntersectionRect(this.a.getX(), this.a.getY(), this.a.getWidth(), this.a.getHeight(), this.b.getX(), this.b.getY(), this.b.getWidth(), this.b.getHeight());
                            if (collisionRect.width <= collisionRect.height) {
                                PreciseCollisionGroup preciseCollisionGroup;
                                if (Math.abs(d5) >= Math.abs(d7)) {
                                    this.collisionX1 += d5 > 0.0 ? (double)(-collisionRect.width) : (double)collisionRect.width;
                                } else {
                                    this.collisionX2 += d7 > 0.0 ? (double)(-collisionRect.width) : (double)collisionRect.width;
                                }
                                this.collisionSide = preciseCollisionGroup.collisionX1 < this.collisionX2 ? 2 : 1;
                            } else {
                                PreciseCollisionGroup preciseCollisionGroup;
                                if (Math.abs(d6) >= Math.abs(d8)) {
                                    this.collisionY1 += d6 > 0.0 ? (double)(-collisionRect.height) : (double)collisionRect.height;
                                } else {
                                    this.collisionY2 += d8 > 0.0 ? (double)(-collisionRect.height) : (double)collisionRect.height;
                                }
                                this.collisionSide = preciseCollisionGroup.collisionY1 < this.collisionY2 ? 8 : 4;
                            }
                        }
                        return true;
                    }
                }
                this.a.nextTrack();
                this.b.nextTrack();
                ++n;
            }
            return false;
        }
        return false;
    }
}

