/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object.collision;

import com.golden.gamedev.object.CollisionManager;
import com.golden.gamedev.object.Sprite;
import com.golden.gamedev.object.collision.BasicCollisionGroup;
import com.golden.gamedev.object.collision.CollisionRect;
import com.golden.gamedev.object.collision.CollisionShape;

public abstract class CollisionGroup
extends BasicCollisionGroup {
    public static final int LEFT_RIGHT_COLLISION = 1;
    public static final int RIGHT_LEFT_COLLISION = 2;
    public static final int TOP_BOTTOM_COLLISION = 4;
    public static final int BOTTOM_TOP_COLLISION = 8;
    protected Sprite sprite1;
    protected Sprite sprite2;
    protected int collisionSide;
    protected double collisionX1;
    protected double collisionY1;
    protected double collisionX2;
    protected double collisionY2;

    public boolean isCollide(Sprite sprite, Sprite sprite2, CollisionShape collisionShape, CollisionShape collisionShape2) {
        if (super.isCollide(sprite, sprite2, collisionShape, collisionShape2)) {
            this.sprite1 = sprite;
            this.sprite2 = sprite2;
            this.collisionSide = 0;
            this.collisionX1 = sprite.getOldX();
            this.collisionY1 = sprite.getOldY();
            this.collisionX2 = sprite2.getOldX();
            this.collisionY2 = sprite2.getOldY();
            double d = sprite.getX() - this.collisionX1;
            double d2 = sprite.getY() - this.collisionY1;
            double d3 = sprite2.getX() - this.collisionX2;
            double d4 = sprite2.getY() - this.collisionY2;
            double d5 = collisionShape.getX();
            double d6 = collisionShape.getY();
            double d7 = collisionShape2.getX();
            double d8 = collisionShape2.getY();
            collisionShape.move(-(d / 2.0), -(d2 / 2.0));
            collisionShape2.move(-(d3 / 2.0), -(d4 / 2.0));
            if (!collisionShape.intersects(collisionShape2)) {
                collisionShape.setLocation(d5, d6);
                collisionShape2.setLocation(d7, d8);
                collisionShape.move(-(d / 4.0), -(d2 / 4.0));
                collisionShape2.move(-(d3 / 4.0), -(d4 / 4.0));
                if (!collisionShape.intersects(collisionShape2)) {
                    collisionShape.setLocation(d5, d6);
                    collisionShape2.setLocation(d7, d8);
                }
            }
            CollisionRect collisionRect = CollisionManager.getIntersectionRect(collisionShape.getX(), collisionShape.getY(), collisionShape.getWidth(), collisionShape.getHeight(), collisionShape2.getX(), collisionShape2.getY(), collisionShape2.getWidth(), collisionShape2.getHeight());
            this.collisionSide = collisionRect.width <= collisionRect.height ? (collisionShape.getX() < collisionShape2.getX() ? 2 : 1) : (collisionShape.getY() < collisionShape2.getY() ? 8 : 4);
            return true;
        }
        return false;
    }

    public void revertPosition1() {
        if ((this.collisionSide & 1) != 0 || (this.collisionSide & 2) != 0) {
            this.sprite1.forceX(this.collisionX1);
        }
        if ((this.collisionSide & 4) != 0 || (this.collisionSide & 8) != 0) {
            this.sprite1.forceY(this.collisionY1);
        }
    }

    public void revertPosition2() {
        if ((this.collisionSide & 1) != 0 || (this.collisionSide & 2) != 0) {
            this.sprite2.forceX(this.collisionX2);
        }
        if ((this.collisionSide & 4) != 0 || (this.collisionSide & 8) != 0) {
            this.sprite2.forceY(this.collisionY2);
        }
    }

    public Sprite getSprite1() {
        return this.sprite1;
    }

    public Sprite getSprite2() {
        return this.sprite2;
    }

    public int getCollisionSide() {
        return this.collisionSide;
    }

    public void printCollisionSide() {
        String string = "Collision Side ->";
        if ((this.collisionSide & 1) != 0) {
            string = string + " Left<->Right";
        }
        if ((this.collisionSide & 2) != 0) {
            string = string + " Right<->Left";
        }
        if ((this.collisionSide & 4) != 0) {
            string = string + " Top<->Bottom";
        }
        if ((this.collisionSide & 8) != 0) {
            string = string + " Bottom<->Top";
        }
        System.out.println(string);
    }
}

