/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object;

import com.golden.gamedev.object.Background;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.Serializable;

public class Sprite
implements Serializable {
    private Background a;
    private double x;
    private double y;
    private double d;
    private double e;
    private double f;
    private double g;
    private static double h;
    private static double i;
    private transient BufferedImage j;
    protected int width;
    protected int height;
    private int m;
    private Object n;
    private int o;
    private boolean p = true;
    private boolean q;

    public Sprite(BufferedImage bufferedImage, double d, double d2) {
        Sprite sprite = this;
        sprite.x = sprite.f = d;
        Sprite sprite2 = this;
        sprite2.y = sprite2.g = d2;
        if (bufferedImage != null) {
            this.j = bufferedImage;
            this.width = bufferedImage.getWidth();
            this.height = bufferedImage.getHeight();
        }
        this.a = Background.getDefaultBackground();
    }

    public Sprite(BufferedImage bufferedImage) {
        this(bufferedImage, 0.0, 0.0);
    }

    public Sprite(double d, double d2) {
        this(null, d, d2);
    }

    public Sprite() {
        this(0.0, 0.0);
    }

    public void setBackground(Background background) {
        this.a = background;
        if (this.a == null) {
            this.a = Background.getDefaultBackground();
        }
    }

    public Background getBackground() {
        return this.a;
    }

    public BufferedImage getImage() {
        return this.j;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.j = bufferedImage;
        Sprite sprite = this;
        sprite.height = 0;
        sprite.width = 0;
        if (bufferedImage != null) {
            this.width = bufferedImage.getWidth();
            this.height = bufferedImage.getHeight();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean moveTo(long l, double d, double d2, double d3) {
        if (this.x == d && this.y == d2) {
            return true;
        }
        double d4 = Math.toRadians(90.0 + Math.toDegrees(Math.atan2(d2 - this.y, d - this.x)));
        double d5 = Math.sin(d4) * d3 * (double)l;
        double d6 = -Math.cos(d4) * d3 * (double)l;
        boolean bl = false;
        boolean bl2 = false;
        if (d5 != 0.0) {
            if (d5 > 0.0) {
                if (this.x + d5 >= d) {
                    d5 = d - this.x;
                    bl = true;
                }
            } else if (this.x + d5 <= d) {
                d5 = d - this.x;
                bl = true;
            }
        } else if (this.x == d) {
            bl = true;
        }
        if (d6 != 0.0) {
            if (d6 > 0.0) {
                if (this.y + d6 >= d2) {
                    d6 = d2 - this.y;
                    bl2 = true;
                }
            } else if (this.y + d6 <= d2) {
                d6 = d2 - this.y;
                bl2 = true;
            }
        } else if (this.y == d2) {
            bl2 = true;
        }
        this.move(d5, d6);
        return bl && bl2;
    }

    public void setLocation(double d, double d2) {
        Sprite sprite = this;
        sprite.f = sprite.x = d;
        Sprite sprite2 = this;
        sprite2.g = sprite2.y = d2;
    }

    public void move(double d, double d2) {
        if (d != 0.0) {
            this.f = this.x;
            this.x += d;
        }
        if (d2 != 0.0) {
            this.g = this.y;
            this.y += d2;
        }
    }

    public void moveX(double d) {
        if (d != 0.0) {
            this.f = this.x;
            this.x += d;
        }
    }

    public void moveY(double d) {
        if (d != 0.0) {
            this.g = this.y;
            this.y += d;
        }
    }

    public void setX(double d) {
        Sprite sprite = this;
        sprite.f = sprite.x = d;
    }

    public void setY(double d) {
        Sprite sprite = this;
        sprite.g = sprite.y = d;
    }

    public void forceX(double d) {
        this.x = d;
    }

    public void forceY(double d) {
        this.y = d;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getOldX() {
        return this.f;
    }

    public double getOldY() {
        return this.g;
    }

    public void setSpeed(double d, double d2) {
        this.d = d;
        this.e = d2;
    }

    public void setHorizontalSpeed(double d) {
        this.d = d;
    }

    public void setVerticalSpeed(double d) {
        this.e = d;
    }

    public void setMovement(double d, double d2) {
        double d3 = Math.toRadians(d2);
        this.setSpeed(Math.sin(d3) * d, -Math.cos(d3) * d);
    }

    public void addHorizontalSpeed(long l, double d, double d2) {
        if (d != 0.0 && l != 0L) {
            this.d += d * (double)l;
            if (d < 0.0) {
                if (this.d < d2) {
                    this.d = d2;
                    return;
                }
            } else if (this.d > d2) {
                this.d = d2;
            }
        }
    }

    public void addVerticalSpeed(long l, double d, double d2) {
        if (d != 0.0 && l != 0L) {
            this.e += d * (double)l;
            if (d < 0.0) {
                if (this.e < d2) {
                    this.e = d2;
                    return;
                }
            } else if (this.e > d2) {
                this.e = d2;
            }
        }
    }

    public double getHorizontalSpeed() {
        return this.d;
    }

    public double getVerticalSpeed() {
        return this.e;
    }

    public double getScreenX() {
        return this.x - this.a.getX() + (double)this.a.getClip().x;
    }

    public double getScreenY() {
        return this.y - this.a.getY() + (double)this.a.getClip().y;
    }

    public boolean isOnScreen(int n, int n2, int n3, int n4) {
        h = this.x - this.a.getX();
        i = this.y - this.a.getY();
        return h + (double)this.width > (double)(-n) && i + (double)this.height > (double)(-n2) && h < (double)(this.a.getClip().width + n3) && i < (double)(this.a.getClip().height + n4);
    }

    public boolean isOnScreen() {
        return this.isOnScreen(0, 0, 0, 0);
    }

    public void update(long l) {
        this.updateMovement(l);
    }

    protected void updateMovement(long l) {
        Sprite sprite = this;
        sprite.move(sprite.d * (double)l, this.e * (double)l);
    }

    public void render(Graphics2D graphics2D) {
        h = this.x - this.a.getX();
        i = this.y - this.a.getY();
        if (!(h + (double)this.width <= 0.0 || i + (double)this.height <= 0.0 || h > (double)this.a.getClip().width || i > (double)this.a.getClip().height)) {
            this.render(graphics2D, (int)(h += (double)this.a.getClip().x), (int)(i += (double)this.a.getClip().y));
        }
    }

    public void render(Graphics2D graphics2D, int n, int n2) {
        graphics2D.drawImage((Image)this.j, n, n2, null);
    }

    public int getID() {
        return this.m;
    }

    public void setID(int n) {
        this.m = n;
    }

    public Object getDataID() {
        return this.n;
    }

    public void setDataID(Object object) {
        this.n = object;
    }

    public int getLayer() {
        return this.o;
    }

    public void setLayer(int n) {
        this.o = n;
    }

    public boolean isActive() {
        return this.p;
    }

    public void setActive(boolean bl) {
        this.p = bl;
    }

    public boolean isImmutable() {
        return this.q;
    }

    public void setImmutable(boolean bl) {
        this.q = true;
    }

    public double getDistance(Sprite sprite) {
        return Math.sqrt(Math.pow(this.getX() - sprite.getX(), 2.0) + Math.pow(this.getY() - sprite.getY(), 2.0));
    }
}

