/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object;

import com.golden.gamedev.object.Background;
import com.golden.gamedev.object.CollisionManager;
import com.golden.gamedev.object.Sprite;
import com.golden.gamedev.object.SpriteGroup;
import com.golden.gamedev.util.Utility;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.Comparator;

public class PlayField {
    private SpriteGroup[] a;
    private Background b;
    private CollisionManager[] c;
    private Sprite[] d;
    private Comparator e;

    public PlayField(Background background) {
        this.b = background;
        SpriteGroup spriteGroup = new SpriteGroup("Extra Group");
        spriteGroup.setBackground(background);
        this.a = new SpriteGroup[1];
        this.a[0] = spriteGroup;
        this.c = new CollisionManager[0];
        this.d = new Sprite[0];
    }

    public PlayField() {
        this(Background.getDefaultBackground());
    }

    public void add(Sprite sprite) {
        this.a[this.a.length - 1].add(sprite);
    }

    public SpriteGroup addGroup(SpriteGroup spriteGroup) {
        SpriteGroup spriteGroup2 = this.a[this.a.length - 1];
        this.a = (SpriteGroup[])Utility.cut(this.a, this.a.length - 1);
        this.a = (SpriteGroup[])Utility.expand(this.a, 2);
        spriteGroup.setBackground(this.b);
        this.a[this.a.length - 2] = spriteGroup;
        this.a[this.a.length - 1] = spriteGroup2;
        return spriteGroup;
    }

    public boolean removeGroup(SpriteGroup spriteGroup) {
        int n = 0;
        while (n < this.a.length - 1) {
            if (this.a[n] == spriteGroup) {
                this.a = (SpriteGroup[])Utility.cut(this.a, n);
                CollisionManager collisionManager = this.getCollisionGroup(spriteGroup);
                if (collisionManager != null) {
                    do {
                        this.removeCollisionGroup(collisionManager);
                    } while ((collisionManager = this.getCollisionGroup(spriteGroup)) != null);
                }
                return true;
            }
            ++n;
        }
        return false;
    }

    public SpriteGroup getGroup(String string) {
        int n = 0;
        while (n < this.a.length) {
            if (this.a[n].getName().equals(string)) {
                return this.a[n];
            }
            ++n;
        }
        return null;
    }

    public SpriteGroup[] getGroups() {
        return this.a;
    }

    public SpriteGroup getExtraGroup() {
        return this.a[this.a.length - 1];
    }

    public void clearPlayField() {
        int n = 0;
        while (n < this.a.length) {
            this.a[n].clear();
            ++n;
        }
    }

    public void addCollisionGroup(SpriteGroup spriteGroup, SpriteGroup spriteGroup2, CollisionManager collisionManager) {
        if (this.getCollisionGroup(spriteGroup, spriteGroup2) != null) {
            System.err.println("WARNING: " + spriteGroup.getName() + " <-> " + spriteGroup2.getName() + " already have a CollisionManager");
            System.err.println("CollisionGroup insertions operation continued");
        }
        this.c = (CollisionManager[])Utility.expand(this.c, 1);
        collisionManager.setCollisionGroup(spriteGroup, spriteGroup2);
        this.c[this.c.length - 1] = collisionManager;
    }

    public boolean removeCollisionGroup(CollisionManager collisionManager) {
        int n = 0;
        while (n < this.c.length) {
            if (this.c[n] == collisionManager) {
                this.c = (CollisionManager[])Utility.cut(this.c, n);
                return true;
            }
            ++n;
        }
        return false;
    }

    public CollisionManager getCollisionGroup(SpriteGroup spriteGroup, SpriteGroup spriteGroup2) {
        int n = 0;
        while (n < this.c.length) {
            if (this.c[n].getGroup1() == spriteGroup && this.c[n].getGroup2() == spriteGroup2) {
                return this.c[n];
            }
            ++n;
        }
        return null;
    }

    public CollisionManager getCollisionGroup(SpriteGroup spriteGroup) {
        int n = 0;
        while (n < this.c.length) {
            if (this.c[n].getGroup1() == spriteGroup || this.c[n].getGroup2() == spriteGroup) {
                return this.c[n];
            }
            ++n;
        }
        return null;
    }

    public CollisionManager[] getCollisionGroups() {
        return this.c;
    }

    public void update(long l) {
        this.updateSpriteGroups(l);
        this.updateBackground(l);
        this.checkCollisions();
    }

    protected void updateBackground(long l) {
        this.b.update(l);
    }

    protected void updateSpriteGroups(long l) {
        int n = 0;
        while (n < this.a.length) {
            if (this.a[n].isActive()) {
                this.a[n].update(l);
            }
            ++n;
        }
    }

    protected void checkCollisions() {
        int n = 0;
        while (n < this.c.length) {
            if (this.c[n].isActive()) {
                this.c[n].checkCollision();
            }
            ++n;
        }
    }

    public void render(Graphics2D graphics2D) {
        this.renderBackground(graphics2D);
        if (this.e == null) {
            this.renderSpriteGroups(graphics2D);
            return;
        }
        this.renderSpriteGroups(graphics2D, this.e);
    }

    protected void renderBackground(Graphics2D graphics2D) {
        this.b.render(graphics2D);
    }

    protected void renderSpriteGroups(Graphics2D graphics2D) {
        int n = 0;
        while (n < this.a.length) {
            if (this.a[n].isActive()) {
                this.a[n].render(graphics2D);
            }
            ++n;
        }
    }

    protected void renderSpriteGroups(Graphics2D graphics2D, Comparator comparator) {
        int n = 0;
        int n2 = this.d.length;
        if (n2 == 0) {
            this.d = new Sprite[100];
            n2 = this.d.length;
        }
        int n3 = 0;
        while (n3 < this.a.length) {
            if (this.a[n3].isActive()) {
                Sprite[] spriteArray = this.a[n3].getSprites();
                int n4 = this.a[n3].getSize();
                int n5 = 0;
                while (n5 < n4) {
                    if (spriteArray[n5].isActive() && spriteArray[n5].isOnScreen()) {
                        if (n >= n2) {
                            this.d = (Sprite[])Utility.expand(this.d, 20);
                            n2 = this.d.length;
                        }
                        this.d[n++] = spriteArray[n5];
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        Arrays.sort(this.d, 0, n, comparator);
        int n6 = 0;
        while (n6 < n) {
            this.d[n6].render(graphics2D);
            ++n6;
        }
    }

    public void clearCache() {
        this.d = null;
        this.d = new Sprite[0];
    }

    public Background getBackground() {
        return this.b;
    }

    public void setBackground(Background background) {
        this.b = background;
        if (this.b == null) {
            this.b = Background.getDefaultBackground();
        }
        int n = 0;
        while (n < this.a.length) {
            this.a[n].setBackground(background);
            ++n;
        }
    }

    public Comparator getComparator() {
        return this.e;
    }

    public void setComparator(Comparator comparator) {
        this.e = comparator;
    }
}

