/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object;

import com.golden.gamedev.object.GameFont;
import com.golden.gamedev.object.font.AdvanceBitmapFont;
import com.golden.gamedev.object.font.BitmapFont;
import com.golden.gamedev.object.font.SystemFont;
import com.golden.gamedev.util.ImageUtil;
import com.golden.gamedev.util.Utility;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class GameFontManager {
    private final Map a = new HashMap(5);

    public void clear() {
        this.a.clear();
    }

    public Object removeFont(Object object) {
        return this.a.remove(object);
    }

    public GameFont getFont(String string) {
        return (GameFont)this.a.get(string);
    }

    public GameFont putFont(String string, GameFont gameFont) {
        return this.a.put(string, gameFont);
    }

    public GameFont getFont(BufferedImage bufferedImage) {
        GameFont gameFont = (GameFont)this.a.get(bufferedImage);
        if (gameFont == null) {
            gameFont = new AdvanceBitmapFont(this.h(bufferedImage));
            this.a.put(bufferedImage, gameFont);
        }
        return gameFont;
    }

    public GameFont getFont(BufferedImage bufferedImage, String string) {
        GameFont gameFont = (GameFont)this.a.get(bufferedImage);
        if (gameFont == null) {
            gameFont = new AdvanceBitmapFont(this.h(bufferedImage), string);
            this.a.put(bufferedImage, gameFont);
        }
        return gameFont;
    }

    private BufferedImage[] h(BufferedImage bufferedImage) {
        int n = bufferedImage.getRGB(0, 0);
        int[] nArray = new int[100];
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        while (n4 < bufferedImage.getWidth()) {
            if (bufferedImage.getRGB(n4, 0) == n) {
                nArray[n2++] = n4 - n3;
                n3 = n4;
                if (n2 >= nArray.length) {
                    nArray = (int[])Utility.expand(nArray, 50);
                }
            }
            ++n4;
        }
        BufferedImage[] bufferedImageArray = new BufferedImage[n2];
        Color color = new Color(bufferedImage.getRGB(1, 0));
        int n5 = bufferedImage.getHeight() - 1;
        int n6 = 0;
        int n7 = 0;
        while (n7 < bufferedImageArray.length) {
            bufferedImageArray[n7] = ImageUtil.applyMask(bufferedImage.getSubimage(n6, 1, nArray[n7], n5), color);
            n6 += nArray[n7];
            ++n7;
        }
        return bufferedImageArray;
    }

    public GameFont getFont(BufferedImage[] bufferedImageArray) {
        GameFont gameFont = (GameFont)this.a.get(bufferedImageArray);
        if (gameFont == null) {
            gameFont = new BitmapFont(bufferedImageArray);
            this.a.put(bufferedImageArray, gameFont);
        }
        return gameFont;
    }

    public GameFont getFont(BufferedImage[] bufferedImageArray, String string) {
        GameFont gameFont = (GameFont)this.a.get(bufferedImageArray);
        if (gameFont == null) {
            gameFont = new BitmapFont(bufferedImageArray, string);
            this.a.put(bufferedImageArray, gameFont);
        }
        return gameFont;
    }

    public GameFont getFont(Font font) {
        return this.getFont(font, null);
    }

    public GameFont getFont(Font font, Color color) {
        GameFont gameFont = (GameFont)this.a.get(font);
        if (gameFont == null) {
            gameFont = color == null ? new SystemFont(font) : new SystemFont(font, color);
            this.a.put(font, gameFont);
        }
        return gameFont;
    }
}

