/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object;

import com.golden.gamedev.object.Sprite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.Serializable;

public class Background
implements Serializable {
    public static Dimension screen = new Dimension(640, 480);
    protected double x;
    protected double y;
    private int d;
    private int e;
    private final Rectangle f;
    private static Background g;

    public static Background getDefaultBackground() {
        if (g == null) {
            g = new Background();
        }
        return g;
    }

    public Background(int n, int n2) {
        Background background = this;
        background.y = 0.0;
        background.x = 0.0;
        this.d = n;
        this.e = n2;
        this.f = new Rectangle(0, 0, Background.screen.width, Background.screen.height);
    }

    public Background() {
        this(Background.screen.width, Background.screen.height);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int getWidth() {
        return this.d;
    }

    public int getHeight() {
        return this.e;
    }

    public void setSize(int n, int n2) {
        this.d = n;
        this.e = n2;
        Background background = this;
        background.setLocation(background.x, this.y);
    }

    public void setLocation(double d, double d2) {
        if (d > (double)(this.d - this.f.width)) {
            d = this.d - this.f.width;
        }
        if (d2 > (double)(this.e - this.f.height)) {
            d2 = this.e - this.f.height;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        this.x = d;
        this.y = d2;
    }

    public void move(double d, double d2) {
        Background background = this;
        background.setLocation(background.x + d, this.y + d2);
    }

    public void setToCenter(int n, int n2, int n3, int n4) {
        this.setLocation(n + n3 / 2 - this.f.width / 2, n2 + n4 / 2 - this.f.height / 2);
    }

    public void setToCenter(Sprite sprite) {
        this.setToCenter((int)sprite.getX(), (int)sprite.getY(), sprite.getWidth(), sprite.getHeight());
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.f.setBounds(n, n2, n3, n4);
    }

    public void setClip(Rectangle rectangle) {
        this.f.setBounds(rectangle);
    }

    public Rectangle getClip() {
        return this.f;
    }

    public void update(long l) {
    }

    public void render(Graphics2D graphics2D) {
        this.render(graphics2D, (int)this.x, (int)this.y, this.f.x, this.f.y, this.d < this.f.width ? this.d : this.f.width, this.e < this.f.height ? this.e : this.f.height);
    }

    public void render(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
    }
}

