/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.funbox;

import com.golden.gamedev.engine.graphics.WindowExitListener;
import com.golden.gamedev.util.ImageUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public abstract class GameSettings
extends JDialog
implements ActionListener,
Runnable {
    protected JCheckBox fullscreen;
    protected JCheckBox bufferstrategy;
    protected JCheckBox sound;
    protected JButton btnOK;
    protected JButton btnCancel;
    protected URL splashImage;

    public GameSettings(URL uRL) {
        super((Frame)null, "Settings", true);
        this.setResizable(false);
        this.addWindowListener(WindowExitListener.getInstance());
        this.setDefaultCloseOperation(2);
        this.splashImage = uRL;
        JPanel jPanel = this.initGUI();
        this.setContentPane(jPanel);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public GameSettings() {
        this((URL)null);
    }

    public GameSettings(boolean bl, boolean bl2) {
        this.initGUI();
        this.fullscreen.setSelected(bl);
        this.bufferstrategy.setSelected(bl2);
        this.dispose();
        this.start();
    }

    public GameSettings(boolean bl) {
        this(bl, true);
    }

    protected JPanel initGUI() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = null;
        if (this.splashImage != null) {
            try {
                jLabel = new JLabel(new ImageIcon(ImageUtil.getImage(this.splashImage)));
            }
            catch (Exception exception) {
                jLabel = null;
            }
        }
        JPanel jPanel2 = this.initSettings();
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
        this.btnOK = new JButton("OK");
        this.btnOK.addActionListener(this);
        this.getRootPane().setDefaultButton(this.btnOK);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.addActionListener(this);
        jPanel3.add(this.btnOK);
        jPanel3.add(this.btnCancel);
        if (jLabel != null) {
            jPanel.add((Component)jLabel, "North");
        }
        if (jPanel2 != null) {
            jPanel.add((Component)jPanel2, "Center");
        }
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    protected JPanel initSettings() {
        boolean bl;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 2));
        Border border = BorderFactory.createEmptyBorder(6, 4, 3, 4);
        jPanel.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createTitledBorder("Game Settings")));
        try {
            bl = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isFullScreenSupported();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            bl = false;
        }
        this.fullscreen = new JCheckBox("Fullscreen", bl);
        this.fullscreen.setEnabled(bl);
        this.fullscreen.setToolTipText(bl ? "fullscreen/windowed mode" : "fullscreen mode not supported");
        this.bufferstrategy = new JCheckBox("Bufferstrategy", true);
        this.bufferstrategy.setToolTipText("turn this off if the game experiencing graphics problem");
        this.sound = new JCheckBox("Sound", true);
        this.sound.setToolTipText("turn on/off sound and music");
        jPanel.add(this.fullscreen);
        jPanel.add(this.bufferstrategy);
        jPanel.add(this.sound);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnOK) {
            this.dispose();
            new Thread(this).start();
            return;
        }
        if (actionEvent.getSource() == this.btnCancel) {
            System.exit(0);
        }
    }

    public void run() {
        this.start();
    }

    public abstract void start();
}

