/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.engine.graphics;

import com.golden.gamedev.engine.BaseGraphics;
import com.golden.gamedev.engine.graphics.WindowExitListener;
import com.golden.gamedev.util.ImageUtil;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.image.BufferStrategy;
import java.awt.image.VolatileImage;

public class WindowedMode
implements BaseGraphics {
    public static final GraphicsDevice DEVICE = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    public static final GraphicsConfiguration CONFIG = DEVICE.getDefaultConfiguration();
    private Frame d;
    private Canvas e;
    private Dimension f;
    private VolatileImage g;
    private BufferStrategy h;
    private Graphics2D i;
    static Class a;

    public WindowedMode(Dimension dimension, boolean bl) {
        this.f = dimension;
        this.d = new Frame("Golden T Game Engine", CONFIG);
        try {
            this.d.setIconImage(ImageUtil.getImage((a == null ? (a = WindowedMode.a("com.golden.gamedev.engine.graphics.WindowedMode")) : a).getResource("Icon.png")));
        }
        catch (Exception exception) {}
        this.d.addWindowListener(WindowExitListener.getInstance());
        this.d.setResizable(false);
        this.d.setIgnoreRepaint(true);
        this.e = new Canvas(CONFIG);
        this.e.setIgnoreRepaint(true);
        this.e.setSize(this.f);
        this.d.setVisible(true);
        Insets insets = this.d.getInsets();
        this.d.setVisible(false);
        this.d.setSize(this.f.width + insets.left + insets.right, this.f.height + insets.top + insets.bottom);
        this.d.add(this.e);
        this.d.pack();
        this.d.setLayout(null);
        this.d.setLocationRelativeTo(null);
        this.d.setVisible(true);
        if (bl) {
            this.c();
        } else {
            this.d();
        }
        this.e.requestFocus();
    }

    private void c() {
        this.e.createBufferStrategy(2);
        while (this.h == null) {
            try {
                this.h = this.e.getBufferStrategy();
            }
            catch (Exception exception) {}
        }
        while (true) {
            try {
                this.getBackBuffer();
                return;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private void d() {
        if (this.g != null) {
            this.g.flush();
            this.g = null;
        }
        this.g = CONFIG.createCompatibleVolatileImage(this.f.width, this.f.height);
    }

    public Graphics2D getBackBuffer() {
        if (this.i == null) {
            if (this.h == null) {
                if (this.g.validate(CONFIG) == 2) {
                    this.d();
                }
                this.i = this.g.createGraphics();
            } else {
                this.i = (Graphics2D)this.h.getDrawGraphics();
            }
        }
        return this.i;
    }

    public boolean flip() {
        this.i.dispose();
        this.i = null;
        if (this.h == null) {
            this.e.getGraphics().drawImage(this.g, 0, 0, null);
            Toolkit.getDefaultToolkit().sync();
            return !this.g.contentsLost();
        }
        this.h.show();
        Toolkit.getDefaultToolkit().sync();
        return !this.h.contentsLost();
    }

    public void cleanup() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {}
        try {
            if (this.d != null) {
                this.d.dispose();
            }
            return;
        }
        catch (Exception exception) {
            System.err.println("ERROR: Shutting down graphics context " + exception);
            System.exit(-1);
            return;
        }
    }

    public Dimension getSize() {
        return this.f;
    }

    public Component getComponent() {
        return this.e;
    }

    public Frame getFrame() {
        return this.d;
    }

    public boolean isBufferStrategy() {
        return this.h != null;
    }

    public String getGraphicsDescription() {
        return "Windowed Mode [" + this.getSize().width + "x" + this.getSize().height + "]" + (this.h != null ? " with BufferStrategy" : "");
    }

    public void setWindowTitle(String string) {
        this.d.setTitle(string);
    }

    public String getWindowTitle() {
        return this.d.getTitle();
    }

    public void setWindowIcon(Image image) {
        try {
            this.d.setIconImage(image);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public Image getWindowIcon() {
        return this.d.getIconImage();
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

