/*
 * Decompiled with CFR 0.152.
 */
package moagg.types.math;

import moagg.types.math.Point;
import moagg.util.ToStringStyle;
import moagg.util.math.SinusTable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Vector {
    private double x = 0.0;
    private double y = 0.0;

    public Vector() {
    }

    public Vector(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector(Point p) {
        this.x = p.getX();
        this.y = p.getY();
    }

    public Vector(Vector v) {
        this.x = v.x;
        this.y = v.y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getX() {
        return this.x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getY() {
        return this.y;
    }

    public double getAbs() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public static double distance(Vector v1, Vector v2) {
        return Vector.sub(v2, v1).getAbs();
    }

    public void addX(double x) {
        this.x += x;
    }

    public void addY(double y) {
        this.y += y;
    }

    public void add(double x, double y) {
        this.addX(x);
        this.addY(y);
    }

    public void add(Vector v) {
        this.add(v.getX(), v.getY());
    }

    public static Vector add(Vector v1, Vector v2) {
        Vector result = new Vector(v1);
        result.add(v2);
        return result;
    }

    public void subX(double x) {
        this.x -= x;
    }

    public void subY(double y) {
        this.y -= y;
    }

    public void sub(double x, double y) {
        this.subX(x);
        this.subY(y);
    }

    public void sub(Vector v) {
        this.sub(v.getX(), v.getY());
    }

    public static Vector sub(Vector v1, Vector v2) {
        Vector result = new Vector(v1);
        result.sub(v2);
        return result;
    }

    public void mul(double scale) {
        this.x *= scale;
        this.y *= scale;
    }

    public static Vector mul(Vector v, double scale) {
        Vector result = new Vector(v);
        result.mul(scale);
        return result;
    }

    public static Vector exp(double absValue, double angle) {
        return new Vector(absValue * SinusTable.sin(angle), absValue * SinusTable.cos(angle));
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.x).append(this.y).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Vector)) {
            return false;
        }
        Vector other = (Vector)obj;
        return new EqualsBuilder().append(this.x, other.getX()).append(this.y, other.getY()).isEquals();
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SIMPLE_STYLE).append("x", this.x).append("y", this.y).toString();
    }
}

