/*
 * Decompiled with CFR 0.152.
 */
package moagg.types.math;

import moagg.types.math.Rectangle;
import moagg.util.ArgumentChecker;

public class Matrix {
    private int xSize = 0;
    private int ySize = 0;
    private double[][] m = null;

    public Matrix(int xSize, int ySize) {
        ArgumentChecker.checkUnsigned(xSize);
        ArgumentChecker.checkUnsigned(ySize);
        this.xSize = xSize;
        this.ySize = ySize;
        this.m = new double[ySize][xSize];
    }

    public Matrix(int xSize, int ySize, double initialValue) {
        this(xSize, ySize);
        this.setAll(initialValue);
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getYSize() {
        return this.ySize;
    }

    public void set(int x, int y, double value) {
        this.m[y][x] = value;
    }

    public double get(int x, int y) {
        return this.m[y][x];
    }

    public void set(Rectangle r, double value) {
        for (int y = r.getY(); y < r.getY() + r.getH(); ++y) {
            for (int x = r.getX(); x < r.getX() + r.getW(); ++x) {
                this.set(x, y, value);
            }
        }
    }

    public void setAll(double value) {
        for (int y = 0; y < this.ySize; ++y) {
            for (int x = 0; x < this.xSize; ++x) {
                this.set(x, y, value);
            }
        }
    }

    public void add(int x, int y, double value) {
        double[] dArray = this.m[y];
        int n = x;
        dArray[n] = dArray[n] + value;
    }

    public void add(Rectangle r, double value) {
        for (int y = r.getY(); y < r.getY() + r.getH(); ++y) {
            for (int x = r.getX(); x < r.getX() + r.getW(); ++x) {
                this.add(x, y, value);
            }
        }
    }
}

