/*
 * Decompiled with CFR 0.152.
 */
package moagg.prefs.player;

import java.util.prefs.Preferences;
import moagg.prefs.AbstractPrefs;
import moagg.types.prefs.Difficulty;
import moagg.types.prefs.GhostPlayback;

public class PlayerPrefs
extends AbstractPrefs {
    private static final String PREF_NAME = "name";
    private static final String PREF_SHIP_TYPE = "ship_type";
    private static final String PREF_DIFFICULTY = "difficulty";
    private static final String PREF_GHOST_RECORD = "ghost_record";
    private static final String PREF_GHOST_PLAYBACK = "ghost_playback";
    private static final String PREF_GHOST_PLAYBACK_NAME = "ghost_playback_name";
    private static final String DEFAULT_NAME = "Player";
    private static final int DEFAULT_SHIP_TYPE = 0;
    private static final boolean DEFAULT_GHOST_RECORD = true;
    private static final String DEFAULT_GHOST_PLAYBACK = "OWN";
    private static final String DEFAULT_GHOST_PLAYBACK_NAME = "Slash";
    private String name = null;
    private int shipType = 0;
    private Difficulty difficulty = null;
    private boolean ghostRecord = false;
    private GhostPlayback ghostPlayback = null;
    private String ghostPlaybackName = null;
    private static PlayerPrefs instance = new PlayerPrefs();

    public static PlayerPrefs getInstance() {
        return instance;
    }

    protected PlayerPrefs() {
        this.prefs = Preferences.userNodeForPackage(PlayerPrefs.class);
        this.name = this.prefs.get(PREF_NAME, DEFAULT_NAME);
        this.shipType = this.prefs.getInt(PREF_SHIP_TYPE, 0);
        String diff = this.prefs.get(PREF_DIFFICULTY, null);
        this.difficulty = diff != null ? Difficulty.fromString(diff) : null;
        this.ghostRecord = this.prefs.getBoolean(PREF_GHOST_RECORD, true);
        this.ghostPlayback = GhostPlayback.fromString(this.prefs.get(PREF_GHOST_PLAYBACK, DEFAULT_GHOST_PLAYBACK));
        this.ghostPlaybackName = this.prefs.get(PREF_GHOST_PLAYBACK_NAME, DEFAULT_GHOST_PLAYBACK_NAME);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.prefs.put(PREF_NAME, name);
    }

    public int getShipType() {
        return this.shipType;
    }

    public void setShipType(int shipType) {
        this.shipType = shipType;
        this.prefs.putInt(PREF_SHIP_TYPE, shipType);
    }

    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
        this.prefs.put(PREF_DIFFICULTY, difficulty.toString());
    }

    public boolean isGhostRecord() {
        return this.ghostRecord;
    }

    public void setGhostRecord(boolean ghostRecord) {
        this.ghostRecord = ghostRecord;
        this.prefs.putBoolean(PREF_GHOST_RECORD, ghostRecord);
    }

    public GhostPlayback getGhostPlayback() {
        return this.ghostPlayback;
    }

    public void setGhostPlayback(GhostPlayback ghostPlayback) {
        this.ghostPlayback = ghostPlayback;
        this.prefs.put(PREF_GHOST_PLAYBACK, ghostPlayback.toString());
    }

    public String getGhostPlaybackName() {
        return this.ghostPlaybackName;
    }

    public void setGhostPlaybackName(String ghostPlaybackName) {
        this.ghostPlaybackName = ghostPlaybackName;
        this.prefs.put(PREF_GHOST_PLAYBACK_NAME, ghostPlaybackName);
    }
}

