/*
 * Decompiled with CFR 0.152.
 */
package moagg.prefs.handicap;

import java.util.HashMap;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import moagg.prefs.AbstractPrefs;
import org.apache.log4j.Logger;

public class HandicapPrefs
extends AbstractPrefs {
    private static Logger log = Logger.getLogger(HandicapPrefs.class);
    private Map<String, MissionInfo> infos = new HashMap<String, MissionInfo>();
    private static HandicapPrefs instance = new HandicapPrefs();

    public static HandicapPrefs getInstance() {
        return instance;
    }

    protected HandicapPrefs() {
        try {
            this.prefs = Preferences.userNodeForPackage(HandicapPrefs.class);
            for (String key : this.prefs.keys()) {
                String[] values = this.prefs.get(key, "").split("/");
                MissionInfo info = new MissionInfo();
                if (values.length == 2) {
                    info.lastPlayed = Integer.valueOf(values[0]);
                    info.handicap = Integer.valueOf(values[1]);
                }
                this.infos.put(key, info);
            }
        }
        catch (BackingStoreException e) {
            log.error("Error reading handicaps", e);
        }
    }

    public int getLastPlayedLevel(String mission) {
        MissionInfo info = this.infos.get(mission);
        return info != null ? info.lastPlayed : 0;
    }

    public int getHandicap(String mission) {
        MissionInfo info = this.infos.get(mission);
        return info != null ? info.handicap : 0;
    }

    public void updateLastPlayedLevel(String mission, int lastPlayed) {
        MissionInfo info = this.ensureMissionInfo(mission);
        info.lastPlayed = lastPlayed;
        this.prefs.put(mission, info.toString());
    }

    public void updateHandicap(String mission, int handicap) {
        MissionInfo info = this.ensureMissionInfo(mission);
        if (handicap <= info.handicap) {
            return;
        }
        info.handicap = handicap;
        this.prefs.put(mission, info.toString());
    }

    protected MissionInfo ensureMissionInfo(String mission) {
        MissionInfo info = this.infos.get(mission);
        if (info == null) {
            info = new MissionInfo();
            this.infos.put(mission, info);
        }
        return info;
    }

    private static class MissionInfo {
        public int lastPlayed = 0;
        public int handicap = 0;

        private MissionInfo() {
        }

        public String toString() {
            return this.lastPlayed + "/" + this.handicap;
        }
    }
}

