/*
 * Decompiled with CFR 0.152.
 */
package moagg.model.object.sprite;

import com.golden.gamedev.object.Timer;
import moagg.model.Activatable;
import moagg.model.object.ActivatableObject;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.OrientationObject;
import moagg.model.object.sprite.AbstractMoaggSprite;
import moagg.types.Orientation;

public class Fountain
extends AbstractMoaggSprite
implements MoaggGameObject,
OrientationObject,
ActivatableObject {
    private static final long serialVersionUID = 1L;
    private Activatable activatable = null;
    private State state = new Initial();
    private Timer onOffTimer = new Timer(0);
    private Orientation orientation = null;
    private int particleSpeed = 0;
    private int particleLifeTime = 0;
    private int particleScatter = 0;

    public void setActivatable(Activatable activatable) {
        this.activatable = activatable;
    }

    public boolean isActivated() {
        return this.state.isActivated();
    }

    public void activate() {
        this.setState(new Activated());
    }

    public void deactivate() {
        this.setState(new Deactivated());
    }

    public void toggle() {
        if (this.isActivated()) {
            this.deactivate();
        } else {
            this.activate();
        }
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public int getParticleSpeed() {
        return this.particleSpeed;
    }

    public void setParticleSpeed(int particleSpeed) {
        this.particleSpeed = particleSpeed;
    }

    public int getParticleLifeTime() {
        return this.particleLifeTime;
    }

    public void setParticleLifeTime(int particleLifeTime) {
        this.particleLifeTime = particleLifeTime;
    }

    public int getParticleScatter() {
        return this.particleScatter;
    }

    public void setParticleScatter(int particleScatter) {
        this.particleScatter = particleScatter;
    }

    protected void setState(State state) {
        this.state = state;
        this.state.onEntry();
    }

    public void update(long elapsedTime) {
        super.update(elapsedTime);
        this.state.update(elapsedTime);
    }

    private class Deactivated
    implements State {
        private Deactivated() {
        }

        public void onEntry() {
            if (Fountain.this.activatable.hasActivation()) {
                Fountain.this.onOffTimer.setActive(false);
            } else if (Fountain.this.activatable.getOffInterval() > 0) {
                Fountain.this.onOffTimer.setActive(true);
                Fountain.this.onOffTimer.setDelay((long)Fountain.this.activatable.getOffInterval());
            } else {
                Fountain.this.onOffTimer.setActive(false);
            }
        }

        public boolean isActivated() {
            return false;
        }

        public void update(long elapsedTime) {
            if (Fountain.this.onOffTimer.action(elapsedTime)) {
                Fountain.this.activate();
            }
        }
    }

    private class Activated
    implements State {
        private Activated() {
        }

        public void onEntry() {
            if (Fountain.this.activatable.hasActivation()) {
                Fountain.this.onOffTimer.setActive(false);
            } else if (Fountain.this.activatable.getOnInterval() > 0) {
                Fountain.this.onOffTimer.setActive(true);
                Fountain.this.onOffTimer.setDelay((long)Fountain.this.activatable.getOnInterval());
            } else {
                Fountain.this.onOffTimer.setActive(false);
            }
        }

        public boolean isActivated() {
            return true;
        }

        public void update(long elapsedTime) {
            if (Fountain.this.onOffTimer.action(elapsedTime)) {
                Fountain.this.deactivate();
            }
        }
    }

    private class InitialDelay
    implements State {
        private InitialDelay() {
        }

        public void onEntry() {
            Fountain.this.onOffTimer.setDelay((long)Fountain.this.activatable.getInitialDelay());
        }

        public boolean isActivated() {
            return false;
        }

        public void update(long elapsedTime) {
            if (Fountain.this.onOffTimer.action(elapsedTime)) {
                Fountain.this.activate();
            }
        }
    }

    private class Initial
    implements State {
        private Initial() {
        }

        public void onEntry() {
        }

        public boolean isActivated() {
            return false;
        }

        public void update(long elapsedTime) {
            if (Fountain.this.activatable.hasActivation()) {
                if (Fountain.this.activatable.getActivation()) {
                    Fountain.this.activate();
                } else {
                    Fountain.this.deactivate();
                }
            } else if (Fountain.this.activatable.getInitialDelay() > 0) {
                Fountain.this.setState(new InitialDelay());
            } else {
                Fountain.this.activate();
            }
        }
    }

    private static interface State {
        public void onEntry();

        public boolean isActivated();

        public void update(long var1);
    }
}

