/*
 * Decompiled with CFR 0.152.
 */
package moagg.model.object.sprite;

import com.golden.gamedev.object.Timer;
import moagg.model.Activatable;
import moagg.model.object.ActivatableObject;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.sprite.AbstractMoaggAnimatedSprite;

public class Barrier
extends AbstractMoaggAnimatedSprite
implements MoaggGameObject,
ActivatableObject {
    private static final long serialVersionUID = 1L;
    private Activatable activatable = null;
    private State state = new Initial();
    private Timer onOffTimer = new Timer(0);

    public void setActivatable(Activatable activatable) {
        this.activatable = activatable;
    }

    public boolean isActivated() {
        return this.state.isActivated();
    }

    public void activate() {
        this.setState(new Activated());
    }

    public void deactivate() {
        this.setState(new Deactivated());
    }

    public void toggle() {
        if (this.isActivated()) {
            this.deactivate();
        } else {
            this.activate();
        }
    }

    protected void setState(State state) {
        this.state = state;
        this.state.onEntry();
    }

    public void update(long elapsedTime) {
        super.update(elapsedTime);
        this.state.update(elapsedTime);
    }

    private class Deactivated
    implements State {
        private Deactivated() {
        }

        public void onEntry() {
            Barrier.this.setAnimationFrame(0, 0);
            if (Barrier.this.activatable.hasActivation()) {
                Barrier.this.onOffTimer.setActive(false);
            } else if (Barrier.this.activatable.getOffInterval() > 0) {
                Barrier.this.onOffTimer.setActive(true);
                Barrier.this.onOffTimer.setDelay((long)Barrier.this.activatable.getOffInterval());
            } else {
                Barrier.this.onOffTimer.setActive(false);
            }
        }

        public boolean isActivated() {
            return false;
        }

        public void update(long elapsedTime) {
            if (Barrier.this.onOffTimer.action(elapsedTime)) {
                Barrier.this.activate();
            }
        }
    }

    private class Activated
    implements State {
        private Activated() {
        }

        public void onEntry() {
            Barrier.this.setAnimationFrame(1, 1);
            if (Barrier.this.activatable.hasActivation()) {
                Barrier.this.onOffTimer.setActive(false);
            } else if (Barrier.this.activatable.getOnInterval() > 0) {
                Barrier.this.onOffTimer.setActive(true);
                Barrier.this.onOffTimer.setDelay((long)Barrier.this.activatable.getOnInterval());
            } else {
                Barrier.this.onOffTimer.setActive(false);
            }
        }

        public boolean isActivated() {
            return true;
        }

        public void update(long elapsedTime) {
            if (Barrier.this.onOffTimer.action(elapsedTime)) {
                Barrier.this.deactivate();
            }
        }
    }

    private class InitialDelay
    implements State {
        private InitialDelay() {
        }

        public void onEntry() {
            Barrier.this.onOffTimer.setDelay((long)Barrier.this.activatable.getInitialDelay());
        }

        public boolean isActivated() {
            return false;
        }

        public void update(long elapsedTime) {
            if (Barrier.this.onOffTimer.action(elapsedTime)) {
                Barrier.this.activate();
            }
        }
    }

    private class Initial
    implements State {
        private Initial() {
        }

        public void onEntry() {
        }

        public boolean isActivated() {
            return false;
        }

        public void update(long elapsedTime) {
            if (Barrier.this.activatable.hasActivation()) {
                if (Barrier.this.activatable.getActivation()) {
                    Barrier.this.activate();
                } else {
                    Barrier.this.deactivate();
                }
            } else if (Barrier.this.activatable.getInitialDelay() > 0) {
                Barrier.this.setState(new InitialDelay());
            } else {
                Barrier.this.activate();
            }
        }
    }

    private static interface State {
        public void onEntry();

        public boolean isActivated();

        public void update(long var1);
    }
}

