/*
 * Decompiled with CFR 0.152.
 */
package moagg.level.xml.factory.object;

import moagg.artwork.object.TurretImageFactory;
import moagg.level.xml.data.object.AbstractDecorationData;
import moagg.level.xml.data.object.TurretData;
import moagg.level.xml.factory.object.AbstractObjectFactory;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.sprite.Turret;
import moagg.model.weapon.AbstractWeapon;
import moagg.model.weapon.ContinuousFireStrategy;
import moagg.model.weapon.turret.AbstractBarrel;
import moagg.model.weapon.turret.BarrelList;
import moagg.model.weapon.turret.BlasterBarrel;
import moagg.model.weapon.turret.LaserBarrel;
import moagg.model.weapon.turret.aiming.AbstractAiming;
import moagg.model.weapon.turret.aiming.FixedAiming;
import moagg.model.weapon.turret.aiming.RandomAiming;
import moagg.model.weapon.turret.aiming.SmartAiming;
import moagg.model.weapon.turret.aiming.SweepAiming;
import org.apache.log4j.Logger;

public class TurretFactory
extends AbstractObjectFactory {
    private static final Logger log = Logger.getLogger(TurretFactory.class);

    public MoaggGameObject createObject(AbstractDecorationData abstractData) {
        log.trace(abstractData);
        TurretData data = (TurretData)abstractData;
        Turret turret = new Turret();
        turret.setID(data.getId());
        turret.setImage(TurretImageFactory.getInstance().getImage(data.getOrientation(), data.getType()));
        turret.setLocation(data.getX() * 16, data.getY() * 16);
        turret.setVisible(data.isVisible());
        turret.setOrientation(data.getOrientation());
        turret.setType(data.getType());
        turret.setDestroyable(this.createDestroyable(data));
        BarrelList weapon = new BarrelList();
        for (TurretData.BarrelData barrelData : data.getBarrels()) {
            weapon.addWeapon(this.createTurretBarrel(barrelData));
        }
        turret.setWeapon(weapon);
        return turret;
    }

    protected AbstractBarrel createTurretBarrel(TurretData.BarrelData barrelData) {
        log.trace(barrelData);
        ContinuousFireStrategy fireStrategy = new ContinuousFireStrategy();
        fireStrategy.setReloadTime(barrelData.getDelay() * 100);
        AbstractWeapon barrel = null;
        switch (barrelData.getWeaponType()) {
            case BLASTER: {
                barrel = new BlasterBarrel();
                break;
            }
            case LASER: {
                barrel = new LaserBarrel();
            }
        }
        barrel.setFireStrategy(fireStrategy);
        AbstractAiming aiming = null;
        switch (barrelData.getType()) {
            case FIXED: {
                FixedAiming fixed = new FixedAiming();
                fixed.setAngle(barrelData.getAngle());
                aiming = fixed;
                break;
            }
            case RANDOM: {
                aiming = new RandomAiming();
                break;
            }
            case SWEEP: {
                SweepAiming sweep = new SweepAiming();
                sweep.setAngle(barrelData.getAngle());
                sweep.setAngleStep(barrelData.getStep());
                aiming = sweep;
                break;
            }
            case SMART: {
                aiming = new SmartAiming();
            }
        }
        ((AbstractBarrel)barrel).setAiming(aiming);
        ((AbstractBarrel)barrel).setSpeed((double)barrelData.getSpeed() / 1000.0);
        barrel.setShoot(true);
        return barrel;
    }
}

