/*
 * Decompiled with CFR 0.152.
 */
package moagg.level.xml.factory.object;

import moagg.artwork.object.TankImageFactory;
import moagg.level.xml.data.object.AbstractDecorationData;
import moagg.level.xml.data.object.TankData;
import moagg.level.xml.factory.object.AbstractObjectFactory;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.sprite.Tank;
import moagg.model.weapon.SingleFireStrategy;
import moagg.model.weapon.tank.Blaster;
import moagg.model.weapon.tank.Laser;
import org.apache.log4j.Logger;

public class TankFactory
extends AbstractObjectFactory {
    private static final Logger log = Logger.getLogger(TankFactory.class);

    public MoaggGameObject createObject(AbstractDecorationData abstractData) {
        log.trace(abstractData);
        TankData data = (TankData)abstractData;
        Tank tank = new Tank();
        tank.setID(data.getId());
        tank.setImage(TankImageFactory.getInstance().getImage());
        tank.setLocation(data.getX() * 16, data.getY() * 16);
        tank.setVisible(data.isVisible());
        tank.setDestroyable(this.createDestroyable(data));
        tank.setMinX(data.getX() * 16);
        tank.setMaxX((data.getX() + data.getW() - 2) * 16);
        tank.setType(data.getType());
        switch (data.getWeaponType()) {
            case BLASTER: {
                tank.setWeapon(new Blaster(new SingleFireStrategy()));
                break;
            }
            case LASER: {
                tank.setWeapon(new Laser(new SingleFireStrategy()));
            }
        }
        return tank;
    }
}

