/*
 * Decompiled with CFR 0.152.
 */
package moagg.level.xml.factory.object;

import moagg.artwork.object.SamBatteryImageFactory;
import moagg.level.xml.data.object.AbstractDecorationData;
import moagg.level.xml.data.object.SamData;
import moagg.level.xml.factory.object.AbstractObjectFactory;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.sprite.Sam;
import moagg.model.weapon.ContinuousFireStrategy;
import moagg.model.weapon.sam.MissileLauncher;
import org.apache.log4j.Logger;

public class SamFactory
extends AbstractObjectFactory {
    private static final Logger log = Logger.getLogger(SamFactory.class);

    public MoaggGameObject createObject(AbstractDecorationData abstractData) {
        log.trace(abstractData);
        SamData data = (SamData)abstractData;
        Sam sam = new Sam();
        sam.setID(data.getId());
        sam.setImage(SamBatteryImageFactory.getInstance().getImage(data.getOrientation()));
        sam.setLocation(data.getX() * 16, data.getY() * 16);
        sam.setVisible(data.isVisible());
        sam.setOrientation(data.getOrientation());
        sam.setDestroyable(this.createDestroyable(data));
        ContinuousFireStrategy fireStrategy = new ContinuousFireStrategy();
        fireStrategy.setReloadTime(data.getMissileDelay() * 1000);
        MissileLauncher weapon = new MissileLauncher();
        weapon.setFireStrategy(fireStrategy);
        weapon.setShoot(true);
        sam.setWeapon(weapon);
        sam.setMissileFuel(data.getMissileFuel() * 1000);
        sam.setMissileHeading(data.getMissileHeading());
        sam.setMissileWarhead(data.getMissileWarhead());
        return sam;
    }
}

