/*
 * Decompiled with CFR 0.152.
 */
package moagg.level.xml.factory.object;

import moagg.artwork.object.TurretImageFactory;
import moagg.level.xml.data.object.AbstractDecorationData;
import moagg.level.xml.data.object.MortarData;
import moagg.level.xml.factory.object.AbstractObjectFactory;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.sprite.Mortar;
import moagg.model.weapon.AbstractWeapon;
import moagg.model.weapon.ContinuousFireStrategy;
import moagg.model.weapon.mortar.AbstractBarrel;
import moagg.model.weapon.mortar.BarrelList;
import moagg.model.weapon.mortar.FixedBarrel;
import moagg.model.weapon.mortar.RandomBarrel;
import moagg.model.weapon.mortar.SmartBarrel;
import moagg.types.TurretType;
import org.apache.log4j.Logger;

public class MortarFactory
extends AbstractObjectFactory {
    private static final Logger log = Logger.getLogger(MortarFactory.class);

    public MoaggGameObject createObject(AbstractDecorationData abstractData) {
        log.trace(abstractData);
        MortarData data = (MortarData)abstractData;
        Mortar mortar = new Mortar();
        mortar.setID(data.getId());
        mortar.setImage(TurretImageFactory.getInstance().getImage(data.getOrientation(), TurretType.BIG_TUBE));
        mortar.setLocation(data.getX() * 16, data.getY() * 16);
        mortar.setVisible(data.isVisible());
        mortar.setType(TurretType.BIG_TUBE);
        mortar.setOrientation(data.getOrientation());
        mortar.setDestroyable(this.createDestroyable(data));
        BarrelList weapon = new BarrelList();
        for (MortarData.BarrelData barrelData : data.getBarrels()) {
            weapon.addWeapon(this.createMortarBarrel(barrelData));
        }
        mortar.setWeapon(weapon);
        return mortar;
    }

    protected AbstractBarrel createMortarBarrel(MortarData.BarrelData barrelData) {
        log.trace(barrelData);
        ContinuousFireStrategy fireStrategy = new ContinuousFireStrategy();
        fireStrategy.setReloadTime(barrelData.getDelay() * 100);
        AbstractWeapon barrel = null;
        switch (barrelData.getType()) {
            case FIXED: {
                FixedBarrel fixed = new FixedBarrel();
                fixed.setAngle(barrelData.getAngle());
                barrel = fixed;
                break;
            }
            case RANDOM: {
                barrel = new RandomBarrel();
                break;
            }
            case SMART: {
                barrel = new SmartBarrel();
            }
        }
        barrel.setFireStrategy(fireStrategy);
        ((AbstractBarrel)barrel).setWarhead(barrelData.getWarhead());
        ((AbstractBarrel)barrel).setSpeed((double)barrelData.getSpeed() / 1000.0);
        ((AbstractBarrel)barrel).setExploderDelay(barrelData.getExploderDelay() * 100);
        barrel.setShoot(true);
        return barrel;
    }
}

