/*
 * Decompiled with CFR 0.152.
 */
package moagg.level.xml.factory.object;

import moagg.artwork.object.GrinderImageFactory;
import moagg.level.xml.data.object.AbstractDecorationData;
import moagg.level.xml.data.object.GrinderData;
import moagg.level.xml.factory.object.AbstractObjectFactory;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.sprite.Grinder;
import moagg.types.math.Vector;
import org.apache.log4j.Logger;

public class GrinderFactory
extends AbstractObjectFactory {
    private static final Logger log = Logger.getLogger(GrinderFactory.class);

    public MoaggGameObject createObject(AbstractDecorationData abstractData) {
        log.trace(abstractData);
        GrinderData data = (GrinderData)abstractData;
        Grinder grinder = new Grinder();
        grinder.setID(data.getId());
        grinder.setImages(GrinderImageFactory.getInstance().getImages());
        grinder.setAnimate(true);
        grinder.setLoopAnim(true);
        grinder.getAnimationTimer().setDelay(20L);
        grinder.setVelocity((double)data.getVelocity() / 1000.0);
        Vector first = null;
        for (GrinderData.WaypointData waypointData : data.getWaypoints()) {
            Vector waypoint = new Vector(waypointData.getX(), waypointData.getY());
            grinder.addWaypoint(waypoint);
            if (first != null) continue;
            first = waypoint;
        }
        grinder.setLocation(first.getX(), first.getY());
        grinder.setVisible(data.isVisible());
        return grinder;
    }
}

